/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.variables;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.InvalidVariableException;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.craftbook.util.profile.Profile;
import org.jspecify.annotations.Nullable;

public class VariableKey {
    private static final Pattern ALLOWED_KEY_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    private final String namespace;
    private final String variable;
    private final boolean explicitNamespace;

    private VariableKey(String namespace, String variable, boolean explicitNamespace) {
        Preconditions.checkNotNull((Object)namespace);
        Preconditions.checkNotNull((Object)variable);
        this.namespace = namespace;
        this.variable = variable;
        this.explicitNamespace = explicitNamespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVariable() {
        return this.variable;
    }

    public String getOriginalForm() {
        if (this.explicitNamespace) {
            return this.namespace + "|" + this.variable;
        }
        return this.variable;
    }

    public Component getRichName() {
        String fakeNamespace;
        TextComponent mainText = this.namespace.contains("-") ? ((fakeNamespace = (String)Optional.ofNullable(CraftBook.getInstance().getProfileCache().getIfPresent(UUID.fromString(this.namespace))).map(Profile::getName).orElse(null)) != null ? (TextComponent)((TextComponent)TextComponent.empty().append((Component)TextComponent.of((String)("*" + fakeNamespace), (TextColor)TextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)TextComponent.of((String)("|" + this.variable), (TextColor)TextColor.WHITE)) : TextComponent.of((String)this.toString(), (TextColor)TextColor.WHITE)) : TextComponent.of((String)this.toString());
        TranslatableComponent copyComponent = TranslatableComponent.of((String)"craftbook.variables.list.copy");
        mainText = this.namespace.contains("-") ? (TextComponent)mainText.hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)this.toString()).append(TextComponent.newline().append((Component)copyComponent)))) : (TextComponent)mainText.hoverEvent(HoverEvent.showText((Component)copyComponent));
        return mainText.clickEvent(ClickEvent.copyToClipboard((String)this.toString()));
    }

    public String toString() {
        return this.namespace + "|" + this.variable;
    }

    public boolean hasPermission(Actor actor, String action) {
        if (this.getNamespace().equals(actor.getUniqueId().toString()) && (actor.hasPermission("craftbook.variables." + action + ".self") || actor.hasPermission("craftbook.variables." + action + ".self." + this.getVariable()))) {
            return true;
        }
        return actor.hasPermission("craftbook.variables." + action + "." + this.getNamespace()) || actor.hasPermission("craftbook.variables." + action + "." + this.getNamespace() + "." + this.getVariable());
    }

    public static @Nullable VariableKey fromString(String line, @Nullable Actor actor) throws VariableException {
        Matcher matcher = VariableManager.DIRECT_VARIABLE_PATTERN.matcher(line);
        if (matcher.find()) {
            String namespace = matcher.group(1);
            String key = matcher.group(2);
            return VariableKey.of(namespace, key, actor);
        }
        return null;
    }

    public static VariableKey of(@Nullable String namespace, String key, @Nullable Actor actor) throws VariableException {
        return VariableKey.of(namespace, key, actor == null ? null : actor.getUniqueId());
    }

    public static VariableKey of(@Nullable String namespace, String key, @Nullable UUID actorUuid) throws VariableException {
        boolean explicit;
        boolean bl = explicit = namespace != null;
        if (!ALLOWED_KEY_PATTERN.matcher(key).matches()) {
            throw new InvalidVariableException((Component)TranslatableComponent.of((String)"craftbook.variables.invalid-key", (Component[])new Component[]{TextComponent.of((String)key)}));
        }
        if (namespace == null || namespace.trim().isEmpty()) {
            namespace = VariableManager.instance.defaultToGlobal || actorUuid == null ? "global" : actorUuid.toString();
        } else if (namespace.contains("-")) {
            try {
                UUID.fromString(namespace);
            }
            catch (IllegalArgumentException ignored) {
                throw new InvalidVariableException((Component)TranslatableComponent.of((String)"craftbook.variables.invalid-namespace", (Component[])new Component[]{TextComponent.of((String)namespace)}));
            }
        } else if (!ALLOWED_KEY_PATTERN.matcher(namespace).matches()) {
            throw new InvalidVariableException((Component)TranslatableComponent.of((String)"craftbook.variables.invalid-namespace", (Component[])new Component[]{TextComponent.of((String)namespace)}));
        }
        return new VariableKey(namespace, key, explicit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableKey)) {
            return false;
        }
        VariableKey that = (VariableKey)o;
        return this.namespace.equals(that.namespace) && this.variable.equals(that.variable);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.variable);
    }
}

