/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.variables;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;

public class VariableConfiguration {
    public final YAMLProcessor config;

    public VariableConfiguration(YAMLProcessor config) {
        this.config = config;
    }

    public void load() {
        try {
            this.config.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (this.config.getKeys("variables") == null) {
            return;
        }
        for (String namespace : this.config.getKeys("variables")) {
            for (String variable : this.config.getNode("variables").getKeys(namespace)) {
                String value = String.valueOf(this.config.getProperty("variables." + namespace + "." + variable));
                try {
                    VariableKey key = VariableKey.of(namespace, variable, (UUID)null);
                    if (VariableManager.DIRECT_VARIABLE_PATTERN.matcher(key.toString()).matches() && VariableManager.ALLOWED_VALUE_PATTERN.matcher(value).find()) {
                        VariableManager.instance.setVariable(key, value);
                        continue;
                    }
                    throw new VariableException((Component)TextComponent.of((String)("Invalid variable " + key.toString() + " with value " + value)), key);
                }
                catch (VariableException e) {
                    CraftBook.LOGGER.error("Invalid variable in variables file", (Throwable)e);
                }
            }
        }
    }

    public void save() {
        this.config.clear();
        for (Map.Entry<String, Map<String, String>> namespaceEntry : VariableManager.instance.getVariableStore().entrySet()) {
            this.config.setProperty("variables." + namespaceEntry.getKey(), namespaceEntry.getValue());
        }
        this.config.save();
    }
}

