/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.variables;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.component.InvalidComponentException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.variables.VariableCommands;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class VariableCommandsRegistration
implements CommandRegistration<VariableCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private VariableCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument variablePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"variable"), (Component)TextComponent.of((String)"The variable name")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument valuePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"value"), (Component)TextComponent.of((String)"The variable value")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag namespacePart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"The namespace of the variable")).withRequiredArg().argNamed(TranslatableComponent.of((String)"namespace")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag allPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"List all variables")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Select page number")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument valuePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"value"), (Component)TextComponent.of((String)"The appended value")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument valuePart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"value"), (Component)TextComponent.of((String)"The prepended value")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument inputPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"input"), (Component)TextComponent.of((String)"Expression to evaluate")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();

    private VariableCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static VariableCommandsRegistration builder() {
        return new VariableCommandsRegistration();
    }

    public VariableCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public VariableCommandsRegistration containerInstance(VariableCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public VariableCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public VariableCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("set", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets a variable."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.valuePart, (Object)this.namespacePart));
            b.action(this::cmd$set);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"set", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("define", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Defines a variable."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.valuePart, (Object)this.namespacePart));
            b.action(this::cmd$define);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"define", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("get", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Checks a variable."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.namespacePart));
            b.action(this::cmd$get);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"get", (Class[])new Class[]{Actor.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Lists variables"));
            b.parts((Collection)ImmutableList.of((Object)this.namespacePart, (Object)this.allPart, (Object)this.pagePart));
            b.action(this::cmd$list);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"list", (Class[])new Class[]{Actor.class, String.class, Boolean.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("remove", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"delete", (Object)"rm"));
            b.description((Component)TextComponent.of((String)"Remove a variable."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.namespacePart));
            b.action(this::cmd$remove);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"remove", (Class[])new Class[]{Actor.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("append", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Append to a variable."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.valuePart2, (Object)this.namespacePart));
            b.action(this::cmd$append);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"append", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("prepend", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Prepend to a variable."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.valuePart3, (Object)this.namespacePart));
            b.action(this::cmd$prepend);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"prepend", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggle", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle a boolean."));
            b.parts((Collection)ImmutableList.of((Object)this.variablePart, (Object)this.namespacePart));
            b.action(this::cmd$toggle);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"toggle", (Class[])new Class[]{Actor.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("setexpr", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set a variable to the result of a calculation."));
            b.parts((Collection)ImmutableList.of((Object)this.namespacePart, (Object)this.variablePart, (Object)this.inputPart));
            b.action(this::cmd$setexpr);
            Method commandMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"setExpr", (Class[])new Class[]{Actor.class, String.class, String.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$set(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"set", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.set(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$value(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$define(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"define", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.define(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$value(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$get(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"get", (Class[])new Class[]{Actor.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.get(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$list(CommandParameters parameters) throws InvalidComponentException, VariableException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"list", (Class[])new Class[]{Actor.class, String.class, Boolean.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.extract$actor(parameters), this.extract$namespace(parameters), this.extract$all(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$remove(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"remove", (Class[])new Class[]{Actor.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.remove(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$append(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"append", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.append(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$value2(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$prepend(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"prepend", (Class[])new Class[]{Actor.class, String.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.prepend(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$value3(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$toggle(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"toggle", (Class[])new Class[]{Actor.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.toggle(this.extract$actor(parameters), this.extract$variable(parameters), this.extract$namespace(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$setexpr(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(VariableCommands.class, (String)"setExpr", (Class[])new Class[]{Actor.class, String.class, String.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.setExpr(this.extract$actor(parameters), this.extract$namespace(parameters), this.extract$variable(parameters), this.extract$input(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private String extract$variable(CommandParameters parameters) {
        return (String)this.variablePart.value(parameters).asSingle(string_Key);
    }

    private String extract$value(CommandParameters parameters) {
        return (String)this.valuePart.value(parameters).asSingle(string_Key);
    }

    private String extract$namespace(CommandParameters parameters) {
        return (String)this.namespacePart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$all(CommandParameters parameters) {
        return this.allPart.in(parameters);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private String extract$value2(CommandParameters parameters) {
        return (String)this.valuePart2.value(parameters).asSingle(string_Key);
    }

    private String extract$value3(CommandParameters parameters) {
        return (String)this.valuePart3.value(parameters).asSingle(string_Key);
    }

    private List<String> extract$input(CommandParameters parameters) {
        return this.inputPart.value(parameters).asMultiple(string_Key);
    }
}

