/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.variables;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.component.InvalidComponentException;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.variables.VariableCommandsRegistration;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.ExistingVariableException;
import org.enginehub.craftbook.mechanics.variables.exception.InvalidVariableException;
import org.enginehub.craftbook.mechanics.variables.exception.UnknownVariableException;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.craftbook.util.profile.Profile;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class VariableCommands {
    public static void register(CommandManager commandManager, CommandRegistrationHandler registration) {
        registration.register(commandManager, (CommandRegistration)VariableCommandsRegistration.builder(), (Object)new VariableCommands());
    }

    @Command(name="set", desc="Sets a variable.")
    @CommandPermissions(value={"craftbook.variables.set"})
    public void set(Actor actor, @Arg(desc="The variable name") String variable, @Arg(desc="The variable value") String value, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "modify");
        this.checkVariableValue(value);
        VariableManager.instance.setVariable(key, value);
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.set", (Component[])new Component[]{key.getRichName(), TextComponent.of((String)value, (TextColor)TextColor.WHITE)}));
    }

    @Command(name="define", desc="Defines a variable.")
    @CommandPermissions(value={"craftbook.variables.define"})
    public void define(Actor actor, @Arg(desc="The variable name") String variable, @Arg(desc="The variable value") String value, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        if (VariableManager.instance.hasVariable(key)) {
            throw new ExistingVariableException(key);
        }
        this.checkVariablePermission(actor, key, "define");
        this.checkVariableValue(value);
        VariableManager.instance.setVariable(key, value);
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.set", (Component[])new Component[]{key.getRichName(), TextComponent.of((String)value, (TextColor)TextColor.WHITE)}));
    }

    @Command(name="get", desc="Checks a variable.")
    @CommandPermissions(value={"craftbook.variables.get"})
    public void get(Actor actor, @Arg(desc="The variable name") String variable, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "get");
        String value = VariableManager.instance.getVariable(key);
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.get", (Component[])new Component[]{key.getRichName(), value == null ? TranslatableComponent.of((String)"craftbook.variables.undefined", (TextColor)TextColor.WHITE) : TextComponent.of((String)value, (TextColor)TextColor.WHITE)}));
    }

    @Command(name="list", desc="Lists variables")
    @CommandPermissions(value={"craftbook.variables.list"})
    public void list(Actor actor, @ArgFlag(name=110, desc="The namespace of the variable") String namespace, @Switch(name=97, desc="List all variables") boolean all, @ArgFlag(name=112, desc="Select page number", def={"1"}) int page) throws InvalidComponentException, VariableException {
        if (!all && namespace == null) {
            namespace = VariableManager.instance.defaultToGlobal || !(actor instanceof CraftBookPlayer) ? "global" : actor.getUniqueId().toString();
        } else if (all && namespace != null) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.variables.list.all-and-namespace"));
            return;
        }
        ArrayList<VariableKey> variableKeys = new ArrayList<VariableKey>();
        if (namespace != null) {
            Set<String> variableNames = VariableManager.instance.getVariableStore().getOrDefault(namespace, (Map<String, String>)ImmutableMap.of()).keySet();
            Iterator iterator = variableNames.iterator();
            while (iterator.hasNext()) {
                String variableName = (String)iterator.next();
                variableKeys.add(VariableKey.of(namespace, variableName, actor));
            }
        } else {
            for (Map.Entry entry : VariableManager.instance.getVariableStore().entrySet()) {
                for (String variable : ((Map)entry.getValue()).keySet()) {
                    variableKeys.add(VariableKey.of((String)entry.getKey(), variable, actor));
                }
            }
        }
        VariableListPaginationBox variableListBox = new VariableListPaginationBox(variableKeys, namespace, "/variables list -p %page% " + (String)(namespace == null ? "-a" : "-n " + namespace));
        actor.printInfo(variableListBox.create(page));
    }

    @Command(name="remove", aliases={"delete", "rm"}, desc="Remove a variable.")
    @CommandPermissions(value={"craftbook.variables.remove"})
    public void remove(Actor actor, @Arg(desc="The variable name") String variable, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "remove");
        VariableManager.instance.removeVariable(key);
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.remove", (Component[])new Component[]{key.getRichName()}));
    }

    @Command(name="append", desc="Append to a variable.")
    @CommandPermissions(value={"craftbook.variables.append"})
    public void append(Actor actor, @Arg(desc="The variable name") String variable, @Arg(desc="The appended value") String value, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "modify");
        this.checkVariableValue(value);
        VariableManager.instance.setVariable(key, VariableManager.instance.getVariable(key) + value);
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.set", (Component[])new Component[]{key.getRichName(), TextComponent.of((String)Objects.requireNonNull(VariableManager.instance.getVariable(key)), (TextColor)TextColor.WHITE)}));
    }

    @Command(name="prepend", desc="Prepend to a variable.")
    @CommandPermissions(value={"craftbook.variables.prepend"})
    public void prepend(Actor actor, @Arg(desc="The variable name") String variable, @Arg(desc="The prepended value") String value, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "modify");
        this.checkVariableValue(value);
        VariableManager.instance.setVariable(key, value + VariableManager.instance.getVariable(key));
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.set", (Component[])new Component[]{key.getRichName(), TextComponent.of((String)Objects.requireNonNull(VariableManager.instance.getVariable(key)), (TextColor)TextColor.WHITE)}));
    }

    @Command(name="toggle", desc="Toggle a boolean.")
    @CommandPermissions(value={"craftbook.variables.toggle"})
    public void toggle(Actor actor, @Arg(desc="The variable name") String variable, @ArgFlag(name=110, desc="The namespace of the variable") String namespace) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "modify");
        String var = VariableManager.instance.getVariable(key);
        if (var != null) {
            String result;
            if (var.equalsIgnoreCase("0") || var.equalsIgnoreCase("1")) {
                result = var.equalsIgnoreCase("1") ? "0" : "1";
            } else if (var.equalsIgnoreCase("true") || var.equalsIgnoreCase("false")) {
                result = var.equalsIgnoreCase("true") ? "false" : "true";
            } else if (var.equalsIgnoreCase("yes") || var.equalsIgnoreCase("no")) {
                result = var.equalsIgnoreCase("yes") ? "no" : "yes";
            } else {
                throw new InvalidVariableException((Component)TranslatableComponent.of((String)"craftbook.variables.not-boolean", (Component[])new Component[]{key.getRichName()}));
            }
            VariableManager.instance.setVariable(key, result);
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.set", (Component[])new Component[]{key.getRichName(), TextComponent.of((String)result, (TextColor)TextColor.WHITE)}));
        }
    }

    @Command(name="setexpr", desc="Set a variable to the result of a calculation.")
    @CommandPermissions(value={"craftbook.variables.setexpr"})
    public void setExpr(Actor actor, @ArgFlag(name=110, desc="The namespace of the variable") String namespace, @Arg(desc="The variable name") String variable, @Arg(desc="Expression to evaluate", variable=true) List<String> input) throws CraftBookException, AuthorizationException {
        VariableKey key = VariableKey.of(namespace, variable, actor);
        this.checkVariableExists(key);
        this.checkVariablePermission(actor, key, "modify");
        String var = VariableManager.instance.getVariable(key);
        if (var != null) {
            Expression expression;
            double f;
            try {
                f = Double.parseDouble(var);
            }
            catch (NumberFormatException e) {
                throw new InvalidVariableException((Component)TranslatableComponent.of((String)"craftbook.variables.not-numeric", (Component[])new Component[]{key.getRichName()}));
            }
            try {
                expression = Expression.compile((String)String.join((CharSequence)" ", input), (String[])new String[]{"var"});
            }
            catch (ExpressionException e) {
                actor.printError((Component)TranslatableComponent.of((String)"worldedit.calc.invalid", (Component[])new Component[]{TextComponent.of((String)String.join((CharSequence)" ", input))}));
                return;
            }
            double result = expression.evaluate(new double[]{f});
            VariableManager.instance.setVariable(key, String.valueOf(result));
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.variables.set", (Component[])new Component[]{key.getRichName(), TextComponent.of((double)result, (TextColor)TextColor.WHITE)}));
        }
    }

    private void checkVariablePermission(Actor actor, VariableKey variableKey, String action) throws AuthorizationException {
        if (!variableKey.hasPermission(actor, action)) {
            throw new AuthorizationException();
        }
    }

    private void checkVariableExists(VariableKey key) throws UnknownVariableException {
        if (!VariableManager.instance.hasVariable(key)) {
            throw new UnknownVariableException(key);
        }
    }

    private void checkVariableValue(String value) throws InvalidVariableException {
        if (!VariableManager.ALLOWED_VALUE_PATTERN.matcher(value).find()) {
            throw new InvalidVariableException((Component)TranslatableComponent.of((String)"craftbook.variables.invalid-value", (Component[])new Component[]{TextComponent.of((String)value)}));
        }
    }

    private static class VariableListPaginationBox
    extends PaginationBox {
        private final List<VariableKey> variableKeys;
        private final boolean singleNamespace;

        private static String getFriendlyNamespaceName(String namespace) {
            if (namespace == null) {
                return "All";
            }
            if (namespace.contains("-")) {
                try {
                    Profile profile = CraftBook.getInstance().getProfileService().findByUuid(UUID.fromString(namespace));
                    if (profile != null) {
                        namespace = profile.getName();
                    }
                }
                catch (IOException | InterruptedException e) {
                    CraftBook.LOGGER.warn("Failed to lookup Minecraft profile", (Throwable)e);
                }
            }
            return namespace;
        }

        private VariableListPaginationBox(List<VariableKey> variableKeys, String namespace, String pageCommand) {
            super("Variables (" + VariableListPaginationBox.getFriendlyNamespaceName(namespace) + ")", pageCommand);
            this.variableKeys = variableKeys;
            this.singleNamespace = namespace != null;
        }

        public Component getComponent(int number) {
            TranslatableComponent value;
            Preconditions.checkArgument((number < this.variableKeys.size() && number >= 0 ? 1 : 0) != 0);
            VariableKey key = this.variableKeys.get(number);
            String label = key.getVariable();
            if (!this.singleNamespace) {
                label = key.toString();
            }
            String varValue = VariableManager.instance.getVariable(key);
            TextColor valueColor = TextColor.GRAY;
            if (varValue == null) {
                value = TranslatableComponent.of((String)"craftbook.variables.undefined");
                valueColor = TextColor.DARK_GRAY;
            } else {
                value = TextComponent.of((String)varValue);
            }
            TextComponent labelComponent = (TextComponent)((TextComponent)TextComponent.of((String)label).color(TextColor.YELLOW)).clickEvent(ClickEvent.copyToClipboard((String)key.toString()));
            TranslatableComponent copyComponent = TranslatableComponent.of((String)"craftbook.variables.list.copy");
            labelComponent = this.singleNamespace ? (TextComponent)labelComponent.hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)key.toString()).append(TextComponent.newline().append((Component)copyComponent)))) : (TextComponent)labelComponent.hoverEvent(HoverEvent.showText((Component)copyComponent));
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().content("").append((Component)labelComponent)).append((Component)TextComponent.of((String)"="))).append(value.color(valueColor))).build();
        }

        public int getComponentsSize() {
            return this.variableKeys.size();
        }
    }
}

