/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.signcopier;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.signcopier.SignEditCommands;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class SignEditCommandsRegistration
implements CommandRegistration<SignEditCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<CraftBookPlayer> craftBookPlayer_Key = Key.of(CraftBookPlayer.class);
    private CommandManager commandManager;
    private SignEditCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument linePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"line"), (Component)TextComponent.of((String)"The line to edit")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument textPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"text"), (Component)TextComponent.of((String)"The text to use")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();

    private SignEditCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SignEditCommandsRegistration builder() {
        return new SignEditCommandsRegistration();
    }

    public SignEditCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SignEditCommandsRegistration containerInstance(SignEditCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public SignEditCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SignEditCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("edit", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Edits the copied sign."));
            b.parts((Collection)ImmutableList.of((Object)this.linePart, (Object)this.textPart));
            b.action(this::cmd$edit);
            Method commandMethod = RegistrationUtil.getCommandMethod(SignEditCommands.class, (String)"editSign", (Class[])new Class[]{CraftBookPlayer.class, Integer.TYPE, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clear", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Clears the copied sign."));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$clear);
            Method commandMethod = RegistrationUtil.getCommandMethod(SignEditCommands.class, (String)"clear", (Class[])new Class[]{CraftBookPlayer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$edit(CommandParameters parameters) throws CraftBookException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SignEditCommands.class, (String)"editSign", (Class[])new Class[]{CraftBookPlayer.class, Integer.TYPE, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.editSign(this.extract$player(parameters), this.extract$line(parameters), this.extract$text(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$clear(CommandParameters parameters) throws CraftBookException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SignEditCommands.class, (String)"clear", (Class[])new Class[]{CraftBookPlayer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clear(this.extract$player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private CraftBookPlayer extract$player(CommandParameters parameters) {
        return (CraftBookPlayer)RegistrationUtil.requireOptional(craftBookPlayer_Key, (String)"player", (Optional)parameters.injectedValue(craftBookPlayer_Key));
    }

    private int extract$line(CommandParameters parameters) {
        return (Integer)this.linePart.value(parameters).asSingle(integer_Key);
    }

    private String extract$text(CommandParameters parameters) {
        return (String)this.textPart.value(parameters).asSingle(string_Key);
    }
}

