/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.signcopier;

import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.signcopier.SignCopier;
import org.enginehub.craftbook.mechanics.signcopier.SignEditCommandsRegistration;
import org.enginehub.craftbook.util.AdventureText3Adapter;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class SignEditCommands {
    private final SignCopier signCopier;

    public static void register(CommandManager commandManager, CommandRegistrationHandler registration, SignCopier signCopier) {
        registration.register(commandManager, (CommandRegistration)SignEditCommandsRegistration.builder(), (Object)new SignEditCommands(signCopier));
    }

    public SignEditCommands(SignCopier signCopier) {
        this.signCopier = signCopier;
    }

    @Command(name="edit", desc="Edits the copied sign.")
    @CommandPermissions(value={"craftbook.signcopier.edit"})
    public void editSign(CraftBookPlayer player, @Arg(desc="The line to edit") int line, @Arg(desc="The text to use", variable=true) String text) throws CraftBookException {
        if (!this.signCopier.hasSign(player.getUniqueId())) {
            throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.signcopier.no-copy"));
        }
        if (line < 1 || line > 4) {
            throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.signcopier.invalid-line"));
        }
        net.kyori.adventure.text.Component message = MiniMessage.miniMessage().deserialize((Object)text);
        this.signCopier.setSignLine(player.getUniqueId(), line - 1, message);
        player.printInfo((Component)TranslatableComponent.of((String)"craftbook.signcopier.edited", (Component[])new Component[]{TextComponent.of((int)line), AdventureText3Adapter.fromAdventure(message)}));
    }

    @Command(name="clear", desc="Clears the copied sign.")
    @CommandPermissions(value={"craftbook.signcopier.clear"})
    public void clear(CraftBookPlayer player) throws CraftBookException {
        if (!this.signCopier.hasSign(player.getUniqueId())) {
            throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.signcopier.no-copy"));
        }
        this.signCopier.clearSign(player.getUniqueId());
        player.printInfo((Component)TranslatableComponent.of((String)"craftbook.signcopier.cleared"));
    }
}

