/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.signcopier;

import com.google.common.collect.Maps;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.util.ItemParser;
import org.jspecify.annotations.Nullable;

public abstract class SignCopier
extends AbstractCraftBookMechanic {
    protected final Map<UUID, SignData<?>> signs = Maps.newHashMap();
    protected ItemType item;
    protected boolean copyColor;
    protected boolean copyGlowing;

    public SignCopier(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public boolean hasSign(UUID uuid) {
        return this.signs.containsKey(uuid);
    }

    public @Nullable SignData<?> getSignData(UUID uuid) {
        return this.signs.get(uuid);
    }

    public void setSignLine(UUID uuid, int lineNumber, Component line) {
        this.signs.get((Object)uuid).lines.set(lineNumber, line);
    }

    public void clearSign(UUID uuid) {
        this.signs.remove(uuid);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("item", "The item for the sign copy tool.");
        this.item = ItemParser.getItem(config.getString("item", ItemTypes.FLINT.id())).getType();
        config.setComment("copy-color", "If the sign copier should also copy the dyed color of the sign.");
        this.copyColor = config.getBoolean("copy-color", true);
        config.setComment("copy-glowing", "If the sign copier should also copy the glowing status of the sign.");
        this.copyGlowing = config.getBoolean("copy-glowing", true);
    }

    public record SignData<T>(List<Component> lines, boolean glowing, @Nullable T color) {
    }
}

