/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.piston;

import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public enum PistonType {
    CRUSH("[Crush]", Set.of(BlockTypes.PISTON, BlockTypes.STICKY_PISTON)),
    SUPER_STICKY("[SuperSticky]", Set.of(BlockTypes.STICKY_PISTON)),
    BOUNCE("[Bounce]", Set.of(BlockTypes.PISTON)),
    SUPER_PUSH("[SuperPush]", Set.of(BlockTypes.PISTON, BlockTypes.STICKY_PISTON));

    private final String signText;
    private final Set<BlockType> allowedBlocks;

    private PistonType(String signText, Set<BlockType> allowedBlocks) {
        this.signText = signText;
        this.allowedBlocks = allowedBlocks;
    }

    public String getSignText() {
        return this.signText;
    }

    public Set<BlockType> getAllowedBlocks() {
        return this.allowedBlocks;
    }

    public static @Nullable PistonType getFromSign(String line) {
        return switch (line) {
            case "[Crush]" -> CRUSH;
            case "[SuperSticky]" -> SUPER_STICKY;
            case "[Bounce]" -> BOUNCE;
            case "[SuperPush]" -> SUPER_PUSH;
            default -> null;
        };
    }
}

