/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.piston;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.piston.PistonType;
import org.enginehub.craftbook.util.BlockParser;

public abstract class BetterPistons
extends AbstractCraftBookMechanic {
    protected boolean enableCrush;
    protected boolean crushInstaKill;
    protected List<BaseBlock> crushBlockBlacklist;
    protected boolean enableSuperPush;
    protected boolean enableSuperSticky;
    protected List<BaseBlock> movementBlacklist;
    protected int maxDistance;
    protected boolean enableBounce;
    protected List<BaseBlock> bounceBlockBlacklist;
    protected double maxBounceVelocity;

    public BetterPistons(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public boolean isEnabled(PistonType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PistonType.CRUSH -> this.enableCrush;
            case PistonType.SUPER_STICKY -> this.enableSuperSticky;
            case PistonType.BOUNCE -> this.enableBounce;
            case PistonType.SUPER_PUSH -> this.enableSuperPush;
        };
    }

    public static List<String> getDefaultBlacklist() {
        return List.of(BlockTypes.OBSIDIAN.id(), BlockTypes.BEDROCK.id(), BlockTypes.NETHER_PORTAL.id(), BlockTypes.END_PORTAL.id(), BlockTypes.END_PORTAL_FRAME.id(), BlockTypes.END_GATEWAY.id());
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("enable-crush", "Enables the Crush mechanic.");
        this.enableCrush = config.getBoolean("enable-crush", true);
        config.setComment("crush-kills-mobs", "Causes Crush to kill mobs as well as break blocks. This includes players.");
        this.crushInstaKill = config.getBoolean("crush-kills-mobs", false);
        config.setComment("crush-block-blacklist", "A list of blocks that the Crush piston cannot break.");
        this.crushBlockBlacklist = BlockParser.getBlocks(config.getStringList("crush-block-blacklist", BetterPistons.getDefaultBlacklist()), true);
        config.setComment("enable-super-sticky", "Enables the SuperSticky mechanic.");
        this.enableSuperSticky = config.getBoolean("enable-super-sticky", true);
        config.setComment("enable-super-push", "Enables the SuperPush mechanic.");
        this.enableSuperPush = config.getBoolean("enable-super-push", true);
        config.setComment("movement-blacklist", "A list of blocks that the movement related BetterPistons can not interact with.");
        this.movementBlacklist = BlockParser.getBlocks(config.getStringList("movement-blacklist", BetterPistons.getDefaultBlacklist()), true);
        config.setComment("enable-bounce", "Enables the Bounce mechanic.");
        this.enableBounce = config.getBoolean("enable-bounce", true);
        config.setComment("bounce-blacklist", "A list of blocks that the Bounce piston can not bounce.");
        this.bounceBlockBlacklist = BlockParser.getBlocks(config.getStringList("bounce-blacklist", BetterPistons.getDefaultBlacklist()), true);
        config.setComment("max-distance", "The maximum distance a BetterPiston can interact with blocks from.");
        this.maxDistance = config.getInt("max-distance", 12);
        config.setComment("bounce-max-velocity", "The maximum velocity bounce pistons can use.");
        this.maxBounceVelocity = config.getDouble("bounce-max-velocity", 5.0);
    }
}

