/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.pipe;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Crafter;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.pipe.PipeFilterEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeFinishEvent;
import org.enginehub.craftbook.mechanics.pipe.PipePutEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeRequestEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeSuckEvent;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.enginehub.craftbook.util.VerifyUtil;

public class Pipes
extends AbstractCraftBookMechanic
implements Listener {
    private boolean pipesDiagonal;
    private BlockStateHolder<?> pipeInsulator;
    private boolean pipeStackPerPull;
    private boolean pipeRequireSign;

    public Pipes(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[pipe]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.circuits.pipes")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        if (ProtectionUtil.shouldUseProtection()) {
            Block pistonBlock = null;
            if (SignUtil.isWallSign(event.getBlock())) {
                pistonBlock = SignUtil.getBackBlock(event.getBlock());
            } else if (SignUtil.isStandingSign(event.getBlock())) {
                if (Pipes.isPiston(event.getBlock().getRelative(BlockFace.DOWN))) {
                    pistonBlock = event.getBlock().getRelative(BlockFace.DOWN);
                } else if (Pipes.isPiston(event.getBlock().getRelative(BlockFace.UP))) {
                    pistonBlock = event.getBlock().getRelative(BlockFace.UP);
                }
            }
            if (pistonBlock != null && Pipes.isPiston(pistonBlock)) {
                Piston pis = (Piston)pistonBlock.getBlockData();
                Block off = pistonBlock.getRelative(pis.getFacing());
                if (InventoryUtil.doesBlockHaveInventory(off) && !ProtectionUtil.canAccessInventory(event.getPlayer(), off)) {
                    if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                        player.printError("area.use-permission");
                    }
                    SignUtil.cancelSignChange(event);
                    return;
                }
            } else {
                player.printError("circuits.pipes.pipe-not-found");
                SignUtil.cancelSignChange(event);
                return;
            }
        }
        event.setLine(1, "[Pipe]");
        player.print("circuits.pipes.create");
    }

    private static boolean isPiston(Block block) {
        Material type = block.getType();
        return type == Material.PISTON || type == Material.STICKY_PISTON;
    }

    private static BukkitChangedSign getSignOnPiston(Block block) {
        BlockData blockData = block.getBlockData();
        BlockFace facing = BlockFace.SELF;
        if (blockData instanceof Directional) {
            Directional directional = (Directional)blockData;
            facing = directional.getFacing();
        }
        for (BlockFace face : LocationUtil.getDirectFaces()) {
            if (face == facing || !SignUtil.isSign(block.getRelative(face)) || !SignUtil.isStandingSign(block.getRelative(face)) && (face == BlockFace.UP || face == BlockFace.DOWN) || SignUtil.isStandingSign(block.getRelative(face)) && face != BlockFace.UP && face != BlockFace.DOWN || !SignUtil.isStandingSign(block.getRelative(face)) && !SignUtil.getBackBlock(block.getRelative(face)).getLocation().equals((Object)block.getLocation())) continue;
            Block relativeBlock = block.getRelative(face);
            Sign sign = (Sign)relativeBlock.getState(false);
            for (Side side : Side.values()) {
                if (!sign.getSide(side).getLine(1).equalsIgnoreCase("[Pipe]")) continue;
                return BukkitChangedSign.create(relativeBlock, side, sign.lines().toArray(new Component[0]), null);
            }
        }
        return null;
    }

    private void searchNearbyPipes(Block block, Set<Vector> visitedPipes, List<ItemStack> items) {
        ArrayDeque<Block> searchQueue = new ArrayDeque<Block>();
        searchQueue.addFirst(block);
        while (!searchQueue.isEmpty()) {
            Block bl = (Block)searchQueue.poll();
            Material blType = bl.getType();
            if (blType == Material.PISTON) {
                Piston p = (Piston)bl.getBlockData();
                BukkitChangedSign sign = Pipes.getSignOnPiston(bl);
                HashSet<ItemStack> pFilters = new HashSet<ItemStack>();
                String[] pExceptions = new HashSet();
                if (sign != null) {
                    for (String line3 : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)))) {
                        pFilters.add(ItemSyntax.getItem(line3.trim()));
                    }
                    for (String line4 : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)))) {
                        pExceptions.add(ItemSyntax.getItem(line4.trim()));
                    }
                    pFilters.removeAll(Collections.singleton(null));
                    pExceptions.removeAll(Collections.singleton(null));
                }
                List<ItemStack> filteredItems = new ArrayList<ItemStack>(VerifyUtil.withoutNulls(ItemUtil.filterItems(items, pFilters, pExceptions)));
                PipeFilterEvent filterEvent = new PipeFilterEvent(bl, items, pFilters, (Set<ItemStack>)pExceptions, filteredItems);
                Bukkit.getPluginManager().callEvent((Event)filterEvent);
                filteredItems = filterEvent.getFilteredItems();
                if (filteredItems.isEmpty()) continue;
                ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                Block fac = bl.getRelative(p.getFacing());
                PipePutEvent event = new PipePutEvent(bl, new ArrayList<ItemStack>(filteredItems), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    if (InventoryUtil.doesBlockHaveInventory(fac)) {
                        InventoryHolder holder = (InventoryHolder)fac.getState();
                        newItems.addAll(InventoryUtil.addItemsToInventory(holder, event.getItems().toArray(new ItemStack[event.getItems().size()])));
                    } else if (fac.getType() == Material.JUKEBOX) {
                        Jukebox juke = (Jukebox)fac.getState();
                        ArrayList<ItemStack> its = new ArrayList<ItemStack>(event.getItems());
                        if (juke.getPlaying() != Material.AIR) {
                            Iterator iter = its.iterator();
                            while (iter.hasNext()) {
                                ItemStack st = (ItemStack)iter.next();
                                if (!st.getType().isRecord()) continue;
                                juke.setPlaying(st.getType());
                                juke.update();
                                iter.remove();
                                break;
                            }
                        }
                        newItems.addAll(its);
                    } else {
                        newItems.addAll(event.getItems());
                    }
                    items.removeAll(filteredItems);
                    items.addAll(newItems);
                }
            } else if (blType == Material.DROPPER) {
                ArrayList<ItemStack> filteredItems;
                BukkitChangedSign sign = Pipes.getSignOnPiston(bl);
                HashSet<ItemStack> pFilters = new HashSet<ItemStack>();
                HashSet<ItemStack> pExceptions = new HashSet<ItemStack>();
                if (sign != null) {
                    for (String line3 : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)))) {
                        pFilters.add(ItemSyntax.getItem(line3.trim()));
                    }
                    for (String line4 : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)))) {
                        pExceptions.add(ItemSyntax.getItem(line4.trim()));
                    }
                    pFilters.removeAll(Collections.singleton(null));
                    pExceptions.removeAll(Collections.singleton(null));
                }
                if ((filteredItems = new ArrayList<ItemStack>(VerifyUtil.withoutNulls(ItemUtil.filterItems(items, pFilters, pExceptions)))).isEmpty()) continue;
                Dropper dropper = (Dropper)bl.getState();
                ArrayList newItems = new ArrayList(dropper.getInventory().addItem(filteredItems.toArray(new ItemStack[filteredItems.size()])).values());
                for (ItemStack stack : dropper.getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(stack)) continue;
                    for (int i = 0; i < stack.getAmount(); ++i) {
                        dropper.drop();
                    }
                }
                items.removeAll(filteredItems);
                items.addAll(newItems);
            }
            if (items.isEmpty()) continue;
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        Block off;
                        Material offType;
                        if (items.isEmpty()) {
                            return;
                        }
                        if (!this.pipesDiagonal) {
                            if (x != 0 && y != 0 || x != 0 && z != 0 || y != 0 && z != 0) {
                                continue;
                            }
                        } else {
                            boolean xIsZ;
                            boolean xIsY = Math.abs(x) == Math.abs(y);
                            boolean bl2 = xIsZ = Math.abs(x) == Math.abs(z);
                            if (xIsY && xIsZ) {
                                if (this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(x, 0, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, y, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, 0, z).getBlockData()))) {
                                    continue;
                                }
                            } else if (xIsY) {
                                if (this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(x, 0, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, y, 0).getBlockData()))) {
                                    continue;
                                }
                            } else if (!xIsZ ? this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, y, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, 0, z).getBlockData())) : this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(x, 0, 0).getBlockData())) && this.pipeInsulator.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)bl.getRelative(0, 0, z).getBlockData()))) continue;
                        }
                        if (!Pipes.isValidPipeBlock(offType = (off = bl.getRelative(x, y, z)).getType()) || visitedPipes.contains(off.getLocation().toVector())) continue;
                        visitedPipes.add(off.getLocation().toVector());
                        if (ItemUtil.isStainedGlass(blType) && ItemUtil.isStainedGlass(offType) && blType != offType) continue;
                        if (offType == Material.GLASS || ItemUtil.isStainedGlass(offType)) {
                            searchQueue.add(off);
                            continue;
                        }
                        if (offType == Material.GLASS_PANE || ItemUtil.isStainedGlassPane(offType)) {
                            Block offsetBlock = off.getRelative(x, y, z);
                            Material offsetBlockType = offsetBlock.getType();
                            if (!Pipes.isValidPipeBlock(offsetBlockType) || visitedPipes.contains(offsetBlock.getLocation().toVector()) || ItemUtil.isStainedGlassPane(offType) && ((ItemUtil.isStainedGlass(blType) || ItemUtil.isStainedGlassPane(blType)) && ItemUtil.getStainedColor(offType) != ItemUtil.getStainedColor(offsetBlockType) || (ItemUtil.isStainedGlass(offsetBlockType) || ItemUtil.isStainedGlassPane(offsetBlockType)) && ItemUtil.getStainedColor(offType) != ItemUtil.getStainedColor(offsetBlockType))) continue;
                            visitedPipes.add(offsetBlock.getLocation().toVector());
                            searchQueue.add(off.getRelative(x, y, z));
                            continue;
                        }
                        if (offType != Material.PISTON) continue;
                        searchQueue.addFirst(off);
                    }
                }
            }
        }
    }

    private static boolean isValidPipeBlock(Material type) {
        return switch (type) {
            case Material.GLASS, Material.PISTON, Material.STICKY_PISTON, Material.DROPPER, Material.GLASS_PANE -> true;
            default -> ItemUtil.isStainedGlass(type) || ItemUtil.isStainedGlassPane(type) || SignUtil.isWallSign(type);
        };
    }

    private void startPipe(Block block, List<ItemStack> items, boolean request) {
        HashSet<ItemStack> filters = new HashSet<ItemStack>();
        HashSet<ItemStack> exceptions = new HashSet<ItemStack>();
        BukkitChangedSign sign = Pipes.getSignOnPiston(block);
        if (sign != null) {
            for (String line3 : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)))) {
                filters.add(ItemSyntax.getItem(line3.trim()));
            }
            for (String line4 : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)))) {
                exceptions.add(ItemSyntax.getItem(line4.trim()));
            }
        }
        filters.removeAll(Collections.singleton(null));
        exceptions.removeAll(Collections.singleton(null));
        HashSet<Vector> visitedPipes = new HashSet<Vector>();
        if (block.getType() == Material.STICKY_PISTON) {
            List<ItemStack> leftovers = new ArrayList<ItemStack>();
            Piston p = (Piston)block.getBlockData();
            Block fac = block.getRelative(p.getFacing());
            Material facType = fac.getType();
            if (facType == Material.CHEST || facType == Material.TRAPPED_CHEST || facType == Material.DROPPER || facType == Material.DISPENSER || facType == Material.HOPPER || facType == Material.BARREL || facType == Material.CHISELED_BOOKSHELF || facType == Material.CRAFTER || facType == Material.DECORATED_POT || Tag.SHULKER_BOXES.isTagged((Keyed)facType)) {
                for (ItemStack stack : ((InventoryHolder)fac.getState()).getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(stack) || !ItemUtil.doesItemPassFilters(stack, filters, exceptions)) continue;
                    items.add(stack);
                    ((InventoryHolder)fac.getState()).getInventory().removeItem(new ItemStack[]{stack});
                    if (this.pipeStackPerPull) break;
                }
                event = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                items.clear();
                items.addAll(event.getItems());
                if (!event.isCancelled()) {
                    visitedPipes.add(fac.getLocation().toVector());
                    this.searchNearbyPipes(block, visitedPipes, items);
                }
                if (!items.isEmpty()) {
                    if (facType == Material.CRAFTER) {
                        leftovers.addAll(InventoryUtil.addItemsToCrafter((Crafter)fac.getState(), items.toArray(new ItemStack[items.size()])));
                    } else {
                        for (ItemStack item : items) {
                            if (item == null) continue;
                            leftovers.addAll(((InventoryHolder)fac.getState()).getInventory().addItem(new ItemStack[]{item}).values());
                        }
                    }
                }
            } else if (facType == Material.FURNACE || facType == Material.BLAST_FURNACE || facType == Material.SMOKER) {
                Furnace f = (Furnace)fac.getState();
                if (!ItemUtil.isStackValid(f.getInventory().getResult())) {
                    return;
                }
                if (!ItemUtil.doesItemPassFilters(f.getInventory().getResult(), filters, exceptions)) {
                    return;
                }
                items.add(f.getInventory().getResult());
                if (f.getInventory().getResult() != null) {
                    f.getInventory().setResult(null);
                }
                PipeSuckEvent event = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                items.clear();
                items.addAll(event.getItems());
                if (!event.isCancelled()) {
                    visitedPipes.add(fac.getLocation().toVector());
                    this.searchNearbyPipes(block, visitedPipes, items);
                }
                if (!items.isEmpty()) {
                    for (ItemStack item : items) {
                        if (item == null) continue;
                        if (f.getInventory().getResult() == null) {
                            f.getInventory().setResult(item);
                            continue;
                        }
                        leftovers.add(ItemUtil.addToStack(f.getInventory().getResult(), item));
                    }
                } else {
                    f.getInventory().setResult(null);
                }
            } else if (facType == Material.JUKEBOX) {
                Jukebox juke = (Jukebox)fac.getState();
                if (juke.getPlaying() != Material.AIR) {
                    items.add(new ItemStack(juke.getPlaying()));
                    PipeSuckEvent event = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    items.clear();
                    items.addAll(event.getItems());
                    if (!event.isCancelled()) {
                        visitedPipes.add(fac.getLocation().toVector());
                        this.searchNearbyPipes(block, visitedPipes, items);
                    }
                    if (!items.isEmpty()) {
                        for (ItemStack item : items) {
                            if (!ItemUtil.isStackValid(item)) continue;
                            block.getWorld().dropItem(BlockUtil.getBlockCentre(block), item);
                        }
                    } else {
                        juke.setPlaying(Material.AIR);
                        juke.update();
                    }
                }
            } else {
                event = new PipeSuckEvent(block, new ArrayList<ItemStack>(items), fac);
                Bukkit.getPluginManager().callEvent((Event)event);
                items.clear();
                items.addAll(event.getItems());
                if (!event.isCancelled() && !items.isEmpty()) {
                    visitedPipes.add(fac.getLocation().toVector());
                    this.searchNearbyPipes(block, visitedPipes, items);
                }
                leftovers.addAll(items);
            }
            PipeFinishEvent fEvent = new PipeFinishEvent(block, leftovers, fac, request);
            Bukkit.getPluginManager().callEvent((Event)fEvent);
            leftovers = fEvent.getItems();
            items.clear();
            if (!leftovers.isEmpty()) {
                for (ItemStack item : leftovers) {
                    if (!ItemUtil.isStackValid(item)) continue;
                    block.getWorld().dropItemNaturally(block.getLocation().add(0.5, 0.5, 0.5), item);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (event.getBlock().getType() == Material.STICKY_PISTON) {
            BukkitChangedSign sign = Pipes.getSignOnPiston(event.getBlock());
            if (this.pipeRequireSign && sign == null) {
                return;
            }
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            this.startPipe(event.getBlock(), new ArrayList<ItemStack>(), false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipeRequest(PipeRequestEvent event) {
        if (event.getBlock().getType() == Material.STICKY_PISTON) {
            BukkitChangedSign sign = Pipes.getSignOnPiston(event.getBlock());
            if (this.pipeRequireSign && sign == null) {
                return;
            }
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            this.startPipe(event.getBlock(), event.getItems(), true);
        }
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("allow-diagonal", "Allow pipes to work diagonally. Required for insulators to work.");
        this.pipesDiagonal = config.getBoolean("allow-diagonal", false);
        config.setComment("insulator-block", "When pipes work diagonally, this block allows the pipe to be insulated to not work diagonally.");
        this.pipeInsulator = BlockParser.getBlock(config.getString("insulator-block", BlockTypes.WHITE_WOOL.id()), true);
        config.setComment("stack-per-move", "This option stops the pipes taking the entire chest on power, and makes it just take a single stack.");
        this.pipeStackPerPull = config.getBoolean("stack-per-move", true);
        config.setComment("require-sign", "Requires pipes to have a [Pipe] sign connected to them. This is the only way to require permissions to make pipes.");
        this.pipeRequireSign = config.getBoolean("require-sign", false);
    }
}

