/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks.station;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.minecart.blocks.station.StationCommands;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class StationCommandsRegistration
implements CommandRegistration<StationCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private StationCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument stationPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.station"), (Component)TextComponent.of((String)"The station to select, or null to view current")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag otherPlayerPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The player to target")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.otherPlayer")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();

    private StationCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static StationCommandsRegistration builder() {
        return new StationCommandsRegistration();
    }

    public StationCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public StationCommandsRegistration containerInstance(StationCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public StationCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public StationCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("station", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Select a CraftBook Minecart station."));
            b.parts((Collection)ImmutableList.of((Object)this.stationPart, (Object)this.otherPlayerPart));
            b.action(this::cmd$station);
            Method commandMethod = RegistrationUtil.getCommandMethod(StationCommands.class, (String)"st", (Class[])new Class[]{Actor.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$station(CommandParameters parameters) throws CraftBookException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(StationCommands.class, (String)"st", (Class[])new Class[]{Actor.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.st(this.extract$actor(parameters), this.extract$station(parameters), this.extract$otherPlayer(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private String extract$station(CommandParameters parameters) {
        return (String)this.stationPart.value(parameters).asSingle(string_Key);
    }

    private String extract$otherPlayer(CommandParameters parameters) {
        return (String)this.otherPlayerPart.value(parameters).asSingle(string_Key);
    }
}

