/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks.station;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import org.bukkit.Bukkit;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.minecart.blocks.station.CartStation;
import org.enginehub.craftbook.mechanics.minecart.blocks.station.StationCommandsRegistration;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class StationCommands {
    private final CartStation cartStation;

    public static void register(CommandManager commandManager, CommandRegistrationHandler registration, CartStation cartStation) {
        registration.register(commandManager, (CommandRegistration)StationCommandsRegistration.builder(), (Object)new StationCommands(cartStation));
    }

    public StationCommands(CartStation cartStation) {
        this.cartStation = cartStation;
    }

    @Command(name="station", desc="Select a CraftBook Minecart station.")
    @CommandPermissions(value={"craftbook.minecartstation.station"})
    public void st(Actor actor, @Arg(desc="The station to select, or null to view current", def={""}) String station, @ArgFlag(name=112, desc="The player to target") String otherPlayer) throws CraftBookException {
        Player player = null;
        if (otherPlayer != null) {
            org.bukkit.entity.Player bukkitPlayer = Bukkit.getPlayer((String)otherPlayer);
            if (bukkitPlayer != null) {
                player = BukkitAdapter.adapt((org.bukkit.entity.Player)bukkitPlayer);
            }
        } else if (actor instanceof Player) {
            player = (Player)actor;
        } else {
            throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.command.player-required"));
        }
        if (player == null) {
            throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.command.unknown-player"));
        }
        if (station == null || station.isBlank()) {
            String stationName = this.cartStation.getStation(player.getUniqueId());
            if (stationName == null) {
                actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.minecartstation.none-selected"));
            } else {
                actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.minecartstation.current-selected", (Component[])new Component[]{TextComponent.of((String)stationName).color(TextColor.AQUA)}));
            }
        } else {
            this.cartStation.setStation(player.getUniqueId(), station);
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.minecartstation.set-to", (Component[])new Component[]{TextComponent.of((String)station).color(TextColor.AQUA)}));
        }
    }
}

