/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks.station;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Minecart;
import org.bukkit.event.EventHandler;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.CartBlockEnterEvent;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.bukkit.events.CartBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import org.enginehub.craftbook.mechanics.minecart.blocks.station.StationCommands;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RedstoneUtil;
import org.enginehub.craftbook.util.SignUtil;

public class CartStation
extends CartBlockMechanism {
    private static final List<String> SIGNS = List.of("Station");
    private final Map<UUID, String> stationSelection = new HashMap<UUID, String>();

    public CartStation(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelCommands((commandManager, registration) -> StationCommands.register(commandManager, registration, this));
        this.stationSelection.clear();
        super.enable();
    }

    @Override
    public void disable() {
        this.stationSelection.clear();
        super.disable();
    }

    public String getStation(UUID player) {
        return this.stationSelection.get(player);
    }

    public void setStation(UUID player, String stationName) {
        this.stationSelection.put(player, stationName);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        this.stationInteraction(event.getMinecart(), event.getBlocks(), false);
    }

    @EventHandler
    public void onBlockPower(CartBlockRedstoneEvent event) {
        this.stationInteraction(event.getMinecart(), event.getBlocks(), true);
    }

    @EventHandler
    public void onVehicleEnter(CartBlockEnterEvent event) {
        if (!event.getBlocks().hasSign()) {
            return;
        }
        this.stationInteraction(event.getMinecart(), event.getBlocks(), false);
    }

    private void stationInteraction(Minecart cart, CartMechanismBlocks blocks, boolean powerChange) {
        if (cart == null || !blocks.matches(this.getBlock())) {
            return;
        }
        Side side = blocks.matches("station");
        if (side == null) {
            return;
        }
        BukkitChangedSign sign = blocks.getChangedSign(side);
        boolean autoStart = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).equalsIgnoreCase("AUTOSTART");
        if (!powerChange && !autoStart) {
            return;
        }
        RedstoneUtil.Power pow = CartStation.isActive(blocks);
        switch (pow) {
            case ON: {
                if (autoStart && powerChange) {
                    return;
                }
                cart.setVelocity(SignUtil.getBack(blocks.sign()).getDirection().multiply(0.2));
                break;
            }
            case OFF: 
            case NA: {
                cart.setVelocity(new Vector(0, 0, 0));
                Location l = blocks.rail().getLocation().add(0.5, 0.0, 0.5);
                cart.teleport(l);
                break;
            }
        }
    }

    @Override
    public List<String> getApplicableSigns() {
        return SIGNS;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the station mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.OBSIDIAN.id()), true));
    }
}

