/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.sign.Side;
import org.bukkit.event.EventHandler;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RegexUtil;

public class CartTeleporter
extends CartBlockMechanism {
    private static final List<String> SIGNS = List.of("TeleCart");

    public CartTeleporter(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        double z;
        double y;
        double x;
        if (event.isMinor() || !event.getBlocks().matches(this.getBlock()) || !event.getBlocks().hasSign()) {
            return;
        }
        Side side = event.getBlocks().matches("telecart");
        if (side == null) {
            return;
        }
        BukkitChangedSign sign = event.getBlocks().getChangedSign(side);
        String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).trim();
        String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)).trim();
        World world = event.getMinecart().getWorld();
        String[] pts = RegexUtil.COMMA_PATTERN.split(line2, 3);
        if (!line3.isEmpty()) {
            world = event.getMinecart().getServer().getWorld(line3);
        }
        try {
            x = Double.parseDouble(pts[0].trim());
            y = Double.parseDouble(pts[1].trim());
            z = Double.parseDouble(pts[2].trim());
        }
        catch (NumberFormatException e) {
            x = event.getFrom().getX();
            y = event.getFrom().getY();
            z = event.getFrom().getZ();
            event.getMinecart().setVelocity(new Vector(0, 0, 0));
        }
        Location loc = new Location(world, x, y, z, event.getMinecart().getLocation().getYaw(), event.getMinecart().getLocation().getPitch()).toCenterLocation();
        loc.getChunk().load(true);
        event.getMinecart().teleport(loc);
    }

    @Override
    public boolean verify(BukkitChangedSign sign, CraftBookPlayer player) {
        String[] pts = RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).trim(), 3);
        try {
            Double.parseDouble(pts[0].trim());
            Double.parseDouble(pts[1].trim());
            Double.parseDouble(pts[2].trim());
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.minecartteleporter.invalid-location-syntax"));
            return false;
        }
        return true;
    }

    @Override
    public List<String> getApplicableSigns() {
        return SIGNS;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "The block the TeleCart mechanic uses.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.EMERALD_BLOCK.id()), true));
    }
}

