/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rail;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.bukkit.mechanic.MechanicTypes;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.mechanics.minecart.blocks.station.CartStation;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class CartSorter
extends CartBlockMechanism {
    private CartStation cartStation;

    public CartSorter(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        super.enable();
        this.cartStation = CraftBook.getInstance().getPlatform().getMechanicManager().getMechanic(MechanicTypes.MINECART_STATION).orElse(null);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (!event.getBlocks().matches(this.getBlock())) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        Side side = event.getBlocks().matches("sort");
        if (side == null) {
            return;
        }
        BukkitChangedSign sign = event.getBlocks().getChangedSign(side);
        String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
        String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
        Hand dir = Hand.STRAIGHT;
        if (this.isSortApplicable(line2, event.getMinecart())) {
            dir = Hand.LEFT;
        } else if (this.isSortApplicable(line3, event.getMinecart())) {
            dir = Hand.RIGHT;
        }
        Rail trackData = (Rail)Material.RAIL.createBlockData();
        BlockFace next = SignUtil.getBack(event.getBlocks().sign());
        block0 : switch (next) {
            case SOUTH: {
                switch (dir.ordinal()) {
                    case 1: {
                        trackData.setShape(Rail.Shape.NORTH_EAST);
                        break block0;
                    }
                    case 2: {
                        trackData.setShape(Rail.Shape.NORTH_WEST);
                        break block0;
                    }
                }
                trackData.setShape(Rail.Shape.NORTH_SOUTH);
                break;
            }
            case NORTH: {
                switch (dir.ordinal()) {
                    case 1: {
                        trackData.setShape(Rail.Shape.SOUTH_WEST);
                        break block0;
                    }
                    case 2: {
                        trackData.setShape(Rail.Shape.SOUTH_EAST);
                        break block0;
                    }
                }
                trackData.setShape(Rail.Shape.NORTH_SOUTH);
                break;
            }
            case WEST: {
                switch (dir.ordinal()) {
                    case 1: {
                        trackData.setShape(Rail.Shape.SOUTH_EAST);
                        break block0;
                    }
                    case 2: {
                        trackData.setShape(Rail.Shape.NORTH_EAST);
                        break block0;
                    }
                }
                trackData.setShape(Rail.Shape.EAST_WEST);
                break;
            }
            case EAST: {
                switch (dir.ordinal()) {
                    case 1: {
                        trackData.setShape(Rail.Shape.NORTH_WEST);
                        break block0;
                    }
                    case 2: {
                        trackData.setShape(Rail.Shape.SOUTH_WEST);
                        break block0;
                    }
                }
                trackData.setShape(Rail.Shape.EAST_WEST);
                break;
            }
            default: {
                return;
            }
        }
        Block targetTrack = event.getBlocks().rail().getRelative(next);
        if (targetTrack.getType() == Material.RAIL) {
            targetTrack.setBlockData((BlockData)trackData);
        }
    }

    public boolean isSortApplicable(String fullLine, Minecart minecart) {
        for (String line : RegexUtil.COMMA_PATTERN.split(fullLine)) {
            if (line.equalsIgnoreCase("All")) {
                return true;
            }
            Entity test = minecart.getPassenger();
            Player player = null;
            if (test instanceof Player) {
                player = (Player)test;
            }
            if ((line.equalsIgnoreCase("Unoccupied") || line.equalsIgnoreCase("Empty")) && minecart.getPassenger() == null) {
                return true;
            }
            if (line.equalsIgnoreCase("Storage") && minecart instanceof StorageMinecart) {
                return true;
            }
            if (line.equalsIgnoreCase("Powered") && minecart instanceof PoweredMinecart) {
                return true;
            }
            if (line.equalsIgnoreCase("Minecart")) {
                return true;
            }
            if ((line.equalsIgnoreCase("Occupied") || line.equalsIgnoreCase("Full")) && minecart.getPassenger() != null) {
                return true;
            }
            if (line.equalsIgnoreCase("Animal") && test instanceof Animals) {
                return true;
            }
            if (line.equalsIgnoreCase("Mob") && test instanceof Monster) {
                return true;
            }
            if ((line.equalsIgnoreCase("Player") || line.equalsIgnoreCase("Ply")) && player != null) {
                return true;
            }
            String[] parts = RegexUtil.COLON_PATTERN.split(line);
            if (parts.length >= 2) {
                if (player != null && parts[0].equalsIgnoreCase("Held")) {
                    try {
                        ItemStack item = ItemSyntax.getItem(parts[1]);
                        if (item.getType() == player.getInventory().getItemInMainHand().getType()) {
                            return true;
                        }
                    }
                    catch (NumberFormatException item) {}
                } else if (player != null && parts[0].equalsIgnoreCase("Ply")) {
                    if (parts[1].equalsIgnoreCase(player.getName())) {
                        return true;
                    }
                } else {
                    if (parts[0].equalsIgnoreCase("Mob")) {
                        String testMob = parts[1];
                        return test.getType().toString().equalsIgnoreCase(testMob);
                    }
                    if (minecart instanceof StorageMinecart && parts[0].equalsIgnoreCase("Ctns")) {
                        StorageMinecart storageCart = (StorageMinecart)minecart;
                        Inventory storageInventory = storageCart.getInventory();
                        if (parts.length == 4) {
                            try {
                                item = ItemSyntax.getItem(parts[1] + ":" + parts[2]);
                                int index = Math.min(Math.max(Integer.parseInt(parts[3]) - 1, 0), storageInventory.getContents().length - 1);
                                ItemStack indexed = storageInventory.getContents()[index];
                                if (indexed != null && indexed.equals((Object)item)) {
                                    return true;
                                }
                            }
                            catch (NumberFormatException item) {}
                        } else if (parts.length == 3) {
                            try {
                                item = ItemSyntax.getItem(parts[1] + parts[2]);
                                if (storageInventory.contains(item)) {
                                    return true;
                                }
                            }
                            catch (NumberFormatException item) {}
                        } else {
                            if (parts[1].equalsIgnoreCase("!")) {
                                for (ItemStack item : storageInventory.getContents()) {
                                    if (item == null) continue;
                                    return false;
                                }
                                return true;
                            }
                            try {
                                item = ItemSyntax.getItem(parts[1]);
                                if (storageInventory.contains(item)) {
                                    return true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (!line.startsWith("#") || this.cartStation == null || player == null) continue;
            String selectedStation = this.cartStation.getStation(player.getUniqueId());
            return line.equalsIgnoreCase("#" + selectedStation);
        }
        return false;
    }

    @Override
    public List<String> getApplicableSigns() {
        return List.of("Sort");
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the sorter mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.NETHERRACK.id()), true));
    }

    private static enum Hand {
        STRAIGHT,
        LEFT,
        RIGHT;

    }
}

