/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.bukkit.block.BlockFace;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Minecart;
import org.bukkit.event.EventHandler;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RedstoneUtil;
import org.enginehub.craftbook.util.SignUtil;

public class CartReverser
extends CartBlockMechanism {
    private static final List<String> SIGNS = List.of("Reverse");

    public CartReverser(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.isMinor() || !event.getBlocks().matches(this.getBlock()) || RedstoneUtil.Power.OFF == CartReverser.isActive(event.getBlocks())) {
            return;
        }
        Side side = event.getBlocks().matches("reverse");
        if (!event.getBlocks().hasSign() || side == null) {
            this.reverseCart(event.getMinecart());
            return;
        }
        BlockFace dir = SignUtil.getBack(event.getBlocks().sign());
        Vector normalVelocity = event.getMinecart().getVelocity().normalize();
        switch (dir) {
            case NORTH: {
                if (normalVelocity.getBlockZ() == -1) break;
                this.reverseCart(event.getMinecart());
                break;
            }
            case SOUTH: {
                if (normalVelocity.getBlockZ() == 1) break;
                this.reverseCart(event.getMinecart());
                break;
            }
            case EAST: {
                if (normalVelocity.getBlockX() == 1) break;
                this.reverseCart(event.getMinecart());
                break;
            }
            case WEST: {
                if (normalVelocity.getBlockX() == -1) break;
                this.reverseCart(event.getMinecart());
                break;
            }
            default: {
                this.reverseCart(event.getMinecart());
            }
        }
    }

    private void reverseCart(Minecart cart) {
        cart.setVelocity(cart.getVelocity().multiply(-1));
    }

    @Override
    public List<String> getApplicableSigns() {
        return SIGNS;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "The block the Cart Reverser mechanic uses.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.WHITE_WOOL.id()), true));
    }
}

