/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RedstoneUtil;

public class CartMessenger
extends CartBlockMechanism {
    public CartMessenger(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.isMinor() || !event.getBlocks().matches(this.getBlock()) || event.getMinecart().getPassengers().isEmpty()) {
            return;
        }
        if (!event.getBlocks().hasSign() || RedstoneUtil.Power.OFF == CartMessenger.isActive(event.getBlocks())) {
            return;
        }
        Entity entity = event.getMinecart().getPassenger();
        if (entity instanceof Player) {
            String line3;
            String line2;
            Player p = (Player)entity;
            Side side = event.getBlocks().matches("print");
            if (side == null) {
                Sign bukkitSign = (Sign)event.getBlocks().sign().getState(false);
                for (Side testSide : Side.values()) {
                    if (!bukkitSign.getSide(testSide).getLine(0).equalsIgnoreCase("[print]")) continue;
                    side = testSide;
                }
            }
            if (side == null) {
                return;
            }
            BukkitChangedSign s = event.getBlocks().getChangedSign(side);
            ArrayList<Object> messages = new ArrayList<Object>();
            boolean stack = false;
            String line1 = PlainTextComponentSerializer.plainText().serialize(s.getLine(1));
            if (!line1.isEmpty() && !line1.equalsIgnoreCase("[print]")) {
                messages.add(line1);
                boolean bl = stack = line1.endsWith("+") || line1.endsWith(" ");
            }
            if (!(line2 = PlainTextComponentSerializer.plainText().serialize(s.getLine(2))).isEmpty()) {
                if (stack) {
                    messages.set(messages.size() - 1, (String)messages.get(messages.size() - 1) + line2);
                    stack = line2.endsWith("+") || line2.endsWith(" ");
                } else {
                    messages.add(line2);
                    boolean bl = stack = line2.endsWith("+") || line2.endsWith(" ");
                }
            }
            if (!(line3 = PlainTextComponentSerializer.plainText().serialize(s.getLine(3))).isEmpty()) {
                if (stack) {
                    messages.set(messages.size() - 1, (String)messages.get(messages.size() - 1) + line3);
                } else {
                    messages.add(line3);
                }
            }
            for (String string : messages) {
                void var11_12;
                if (stack) {
                    String string2 = string.replace("+", "");
                }
                p.sendMessage((String)var11_12);
            }
        }
    }

    @Override
    public List<String> getApplicableSigns() {
        return List.of("Print");
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the messager mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.END_STONE.id()), true));
    }
}

