/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.BoundingBox;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.util.RailUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public record CartMechanismBlocks(Block rail, Block base, Block sign) {
    public @Nullable Side matches(String ... testText) {
        if (!this.hasSign()) {
            return null;
        }
        Sign bukkitSign = (Sign)this.sign.getState(false);
        for (Side side : Side.values()) {
            for (String test : testText) {
                if (!bukkitSign.getSide(side).getLine(1).equalsIgnoreCase("[" + test + "]")) continue;
                return side;
            }
        }
        return null;
    }

    public boolean matches(String testText, Side side) {
        if (!this.hasSign()) {
            return false;
        }
        return PlainTextComponentSerializer.plainText().serialize(this.getChangedSign(side).getLine(1)).equalsIgnoreCase("[" + testText + "]");
    }

    public boolean matches(BaseBlock mat) {
        return mat.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)this.base.getBlockData()));
    }

    public boolean hasSign() {
        return this.sign != null && SignUtil.isSign(this.sign);
    }

    public boolean hasRail() {
        return this.rail != null;
    }

    public boolean hasBase() {
        return this.base != null;
    }

    public BukkitChangedSign getChangedSign(Side side) {
        return this.hasSign() ? BukkitChangedSign.create(this.sign, side) : null;
    }

    public @Nullable Minecart findMinecart() {
        if (!this.hasRail()) {
            return null;
        }
        BoundingBox railBox = BoundingBox.of((Block)this.rail);
        for (Entity ent : this.rail.getChunk().getEntities()) {
            Minecart cart;
            if (!(ent instanceof Minecart) || !railBox.contains((cart = (Minecart)ent).getBoundingBox())) continue;
            return cart;
        }
        return null;
    }

    public static @Nullable CartMechanismBlocks find(Block unknown) {
        if (SignUtil.isSign(unknown)) {
            return CartMechanismBlocks.findBySign(unknown);
        }
        if (RailUtil.isTrack(BukkitAdapter.asBlockType((Material)unknown.getType()))) {
            return CartMechanismBlocks.findByRail(unknown);
        }
        return CartMechanismBlocks.findByBase(unknown);
    }

    public static @Nullable CartMechanismBlocks findByRail(Block rail) {
        if (!RailUtil.isTrack(BukkitAdapter.asBlockType((Material)rail.getType()))) {
            return null;
        }
        BlockFace face = BlockFace.DOWN;
        if (rail.getType() == Material.LADDER) {
            face = ((Directional)rail.getBlockData()).getFacing().getOppositeFace();
        } else if (rail.getType() == Material.VINE) {
            MultipleFacing vine = (MultipleFacing)rail.getBlockData();
            for (BlockFace test : vine.getAllowedFaces()) {
                if (!vine.hasFace(test)) continue;
                face = test.getOppositeFace();
                break;
            }
        }
        if (SignUtil.isSign(rail.getRelative(face, 2))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 2));
        }
        if (SignUtil.isSign(rail.getRelative(face, 3))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 3));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.EAST, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.EAST, 1));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.WEST, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.WEST, 1));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.NORTH, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.NORTH, 1));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.SOUTH, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.SOUTH, 1));
        }
        return new CartMechanismBlocks(rail, rail.getRelative(face, 1), null);
    }

    private static @Nullable CartMechanismBlocks findByBase(Block base) {
        if (!RailUtil.isTrack(BukkitAdapter.asBlockType((Material)base.getRelative(BlockFace.UP, 1).getType()))) {
            return null;
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.DOWN, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.DOWN, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.DOWN, 2))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.DOWN, 2));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.EAST, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.EAST, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.WEST, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.WEST, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.NORTH, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.NORTH, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.SOUTH, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.SOUTH, 1));
        }
        return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, null);
    }

    private static @Nullable CartMechanismBlocks findBySign(Block sign) {
        if (!SignUtil.isSign(sign)) {
            return null;
        }
        if (RailUtil.isTrack(BukkitAdapter.asBlockType((Material)sign.getRelative(BlockFace.UP, 2).getType()))) {
            return new CartMechanismBlocks(sign.getRelative(BlockFace.UP, 2), sign.getRelative(BlockFace.UP, 1), sign);
        }
        if (RailUtil.isTrack(BukkitAdapter.asBlockType((Material)sign.getRelative(BlockFace.UP, 3).getType()))) {
            return new CartMechanismBlocks(sign.getRelative(BlockFace.UP, 3), sign.getRelative(BlockFace.UP, 2), sign);
        }
        if (RailUtil.isTrack(BukkitAdapter.asBlockType((Material)sign.getRelative(SignUtil.getBack(sign), 1).getRelative(BlockFace.UP, 1).getType()))) {
            return new CartMechanismBlocks(sign.getRelative(SignUtil.getBack(sign), 1).getRelative(BlockFace.UP, 1), sign.getRelative(SignUtil.getBack(sign), 1), sign);
        }
        return null;
    }
}

