/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.block.sign.Side;
import org.bukkit.event.EventHandler;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RedstoneUtil;

public class CartMaxSpeed
extends CartBlockMechanism {
    public CartMaxSpeed(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.isMinor() || !event.getBlocks().matches(this.getBlock())) {
            return;
        }
        if (RedstoneUtil.Power.OFF == CartMaxSpeed.isActive(event.getBlocks())) {
            return;
        }
        Side side = event.getBlocks().matches("maxspeed");
        double maxSpeed = 0.4;
        if (side != null) {
            try {
                maxSpeed = Double.parseDouble(PlainTextComponentSerializer.plainText().serialize(event.getBlocks().getChangedSign(side).getLine(2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        event.getMinecart().setMaxSpeed(maxSpeed);
    }

    @Override
    public boolean verify(BukkitChangedSign sign, CraftBookPlayer player) {
        try {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            if (!line2.isEmpty()) {
                Double.parseDouble(line2);
            }
        }
        catch (NumberFormatException e) {
            player.printError("Line 3 must be a number that represents the max speed!");
            return false;
        }
        return true;
    }

    @Override
    public List<String> getApplicableSigns() {
        return List.of("MaxSpeed");
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the max speed mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.COAL_BLOCK.id()), true));
    }
}

