/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RedstoneUtil;
import org.enginehub.craftbook.util.SignUtil;

public class CartLift
extends CartBlockMechanism {
    private static final List<String> SIGNS = List.of("CartLift Up", "CartLift Down", "CartLift");

    public CartLift(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        BlockFace face;
        if (event.isMinor() || !event.getBlocks().matches(this.getBlock()) || RedstoneUtil.Power.OFF == CartLift.isActive(event.getBlocks())) {
            return;
        }
        Side side = event.getBlocks().matches("cartlift up", "cartlift down");
        if (side == null) {
            return;
        }
        Minecart cart = event.getMinecart();
        boolean up = event.getBlocks().matches("cartlift up", side);
        Block destination = event.getBlocks().sign();
        Material baseType = event.getBlocks().base().getType();
        BlockFace blockFace = face = up ? BlockFace.UP : BlockFace.DOWN;
        while (true) {
            if (destination.getLocation().getBlockY() <= 0 && !up) {
                return;
            }
            if (destination.getLocation().getBlockY() >= destination.getWorld().getMaxHeight() - 1 && up) {
                return;
            }
            if (!SignUtil.isSign(destination = destination.getRelative(face)) || baseType != destination.getRelative(BlockFace.UP, 1).getType()) continue;
            BukkitChangedSign state = BukkitChangedSign.create(destination, side);
            String testLine = PlainTextComponentSerializer.plainText().serialize(state.getLine(1));
            if (testLine.equalsIgnoreCase("[CartLift Up]") || testLine.equalsIgnoreCase("[CartLift Down]") || testLine.equalsIgnoreCase("[CartLift]")) break;
        }
        destination = destination.getRelative(BlockFace.UP, 2);
        Vector oldVelocity = cart.getVelocity();
        Location newLocation = destination.getLocation();
        newLocation.setDirection(cart.getLocation().getDirection());
        cart.teleport(newLocation);
        cart.setVelocity(oldVelocity);
        for (Entity entity : cart.getPassengers()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(player);
            localPlayer.printInfo((Component)TranslatableComponent.of((String)(up ? "craftbook.minecartelevator.moved-up" : "craftbook.minecartelevator.moved-down")));
        }
    }

    @Override
    public List<String> getApplicableSigns() {
        return SIGNS;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the elevator mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.NETHER_BRICKS.id()), true));
    }
}

