/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.RedstoneUtil;
import org.enginehub.craftbook.util.SignUtil;

public class CartEjector
extends CartBlockMechanism {
    private static final List<String> SIGNS = List.of("Eject");

    public CartEjector(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.getMinecart().isEmpty() || !event.getBlocks().matches(this.getBlock()) || RedstoneUtil.Power.OFF == CartEjector.isActive(event.getBlocks())) {
            return;
        }
        List passengers = event.getMinecart().getPassengers();
        event.getMinecart().eject();
        if (event.getBlocks().matches("eject") != null) {
            Block ejectTarget = event.getBlocks().rail().getRelative(SignUtil.getFront(event.getBlocks().sign()));
            for (Entity ent : passengers) {
                ent.teleport(ejectTarget.getLocation().toCenterLocation());
            }
        }
    }

    @Override
    public List<String> getApplicableSigns() {
        return SIGNS;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "The block the Cart Ejector mechanic uses.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.IRON_BLOCK.id()), true));
    }
}

