/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.BlockFace;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.bukkit.events.CartBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.EntityUtil;
import org.enginehub.craftbook.util.RailUtil;
import org.enginehub.craftbook.util.RedstoneUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public class CartDispenser
extends CartBlockMechanism {
    private static final List<String> SIGNS = List.of("Dispenser");
    private boolean checkForCarts;
    private boolean propelCart;

    public CartDispenser(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public boolean verify(BukkitChangedSign sign, CraftBookPlayer player) {
        String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
        boolean inf = "inf".equalsIgnoreCase(line2);
        if (inf && !player.hasPermission("craftbook.minecartdispenser.infinite")) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.minecartdispenser.infinite-permissions"));
            return false;
        }
        return super.verify(sign, player);
    }

    @EventHandler
    public void onCartImpact(CartBlockImpactEvent event) {
        this.performMechanic(event.getMinecart(), event.getBlocks());
    }

    @EventHandler
    public void onRedstoneImpact(CartBlockRedstoneEvent event) {
        this.performMechanic(event.getMinecart(), event.getBlocks());
    }

    private void performMechanic(@Nullable Minecart cart, CartMechanismBlocks blocks) {
        boolean canDispense;
        if (!blocks.matches(this.getBlock())) {
            return;
        }
        Side side = blocks.matches("dispenser");
        if (side == null) {
            return;
        }
        BukkitChangedSign sign = blocks.getChangedSign(side);
        RedstoneUtil.Power pow = CartDispenser.isActive(blocks);
        String line0 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(0));
        String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
        String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
        EntityType type = this.parseMinecartType(line0);
        boolean inf = "inf".equalsIgnoreCase(line2);
        boolean canCollect = cart != null && !line3.toLowerCase(Locale.ENGLISH).contains("dispense");
        boolean bl = canDispense = cart == null && !line3.toLowerCase(Locale.ENGLISH).contains("collect");
        if (!canCollect && !canDispense) {
            return;
        }
        if (inf) {
            this.tryAction(blocks, pow, cart, null, type, canCollect, canDispense);
        } else {
            for (BlockInventoryHolder container : RailUtil.getNearbyInventoryBlocks(blocks)) {
                Inventory inv = container.getInventory();
                if (!this.tryAction(blocks, pow, cart, inv, type, canCollect, canDispense)) continue;
                return;
            }
        }
    }

    private boolean tryAction(CartMechanismBlocks blocks, RedstoneUtil.Power pow, @Nullable Minecart cart, @Nullable Inventory inv, EntityType type, boolean canCollect, boolean canDispense) {
        if (canDispense) {
            return switch (pow) {
                default -> throw new MatchException(null, null);
                case RedstoneUtil.Power.OFF, RedstoneUtil.Power.NA -> false;
                case RedstoneUtil.Power.ON -> {
                    this.dispense(blocks, inv, type);
                    yield true;
                }
            };
        }
        if (canCollect) {
            return switch (pow) {
                default -> throw new MatchException(null, null);
                case RedstoneUtil.Power.ON -> false;
                case RedstoneUtil.Power.OFF, RedstoneUtil.Power.NA -> {
                    this.collect(cart, inv);
                    yield true;
                }
            };
        }
        return false;
    }

    private void collect(@Nullable Minecart cart, @Nullable Inventory inv) {
        if (cart == null || cart.isDead()) {
            return;
        }
        if (inv != null) {
            inv.addItem(new ItemStack[]{new ItemStack(cart.getMinecartMaterial(), 1)});
        }
        cart.eject();
        cart.remove();
    }

    private void dispense(CartMechanismBlocks blocks, @Nullable Inventory inv, EntityType type) {
        Location location = blocks.rail().getLocation().toCenterLocation();
        if (this.checkForCarts && EntityUtil.isEntityOfTypeInBlock(location.getBlock(), type)) {
            return;
        }
        if (inv != null) {
            Material cartMaterial;
            switch (type) {
                case CHEST_MINECART: {
                    Material material = Material.CHEST_MINECART;
                    break;
                }
                case FURNACE_MINECART: {
                    Material material = Material.FURNACE_MINECART;
                    break;
                }
                case HOPPER_MINECART: {
                    Material material = Material.HOPPER_MINECART;
                    break;
                }
                case COMMAND_BLOCK_MINECART: {
                    Material material = Material.COMMAND_BLOCK_MINECART;
                    break;
                }
                case TNT_MINECART: {
                    Material material = Material.TNT_MINECART;
                    break;
                }
                default: {
                    Material material = cartMaterial = Material.MINECART;
                }
            }
            if (!inv.contains(cartMaterial)) {
                return;
            }
            inv.removeItem(new ItemStack[]{new ItemStack(cartMaterial, 1)});
        }
        Minecart cart = (Minecart)blocks.rail().getWorld().spawn(location, type.getEntityClass());
        if (this.propelCart) {
            BlockFace dir = SignUtil.getBack(blocks.sign());
            cart.setVelocity(dir.getDirection());
        }
    }

    private @Nullable EntityType parseMinecartType(String text) {
        return switch (text.toLowerCase(Locale.ENGLISH)) {
            case "hopper" -> EntityType.HOPPER_MINECART;
            case "tnt" -> EntityType.TNT_MINECART;
            case "powered" -> EntityType.FURNACE_MINECART;
            case "storage" -> EntityType.CHEST_MINECART;
            case "minecart", "rideable" -> EntityType.MINECART;
            case "command" -> EntityType.COMMAND_BLOCK_MINECART;
            case "mob" -> EntityType.SPAWNER_MINECART;
            default -> {
                EntityType type = (EntityType)Registry.ENTITY_TYPE.get(NamespacedKey.fromString((String)text.toLowerCase(Locale.ENGLISH)));
                if (type == null || type.getEntityClass() == null || !Minecart.class.isAssignableFrom(type.getEntityClass())) {
                    yield null;
                }
                yield type;
            }
        };
    }

    @Override
    public List<String> getApplicableSigns() {
        return SIGNS;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the dispenser mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.EMERALD_ORE.id()), true));
        config.setComment("check-for-carts", "If true, the dispenser will not dispense a cart if there is already one in the dispenser's block.");
        this.checkForCarts = config.getBoolean("check-for-carts", true);
        config.setComment("propel-cart", "Propels carts when they are dispensed.");
        this.propelCart = config.getBoolean("propel-cart", true);
    }
}

