/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.ItemInfo;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RailUtil;
import org.enginehub.craftbook.util.RedstoneUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.Tuple2;

public class CartDeposit
extends CartBlockMechanism {
    public CartDeposit(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.isMinor()) {
            return;
        }
        if (!event.getBlocks().matches(this.getBlock())) {
            return;
        }
        if (!(event.getMinecart() instanceof StorageMinecart)) {
            return;
        }
        if (RedstoneUtil.Power.OFF == CartDeposit.isActive(event.getBlocks())) {
            return;
        }
        if (!event.getBlocks().hasSign()) {
            return;
        }
        Side side = event.getBlocks().matches("collect", "deposit");
        if (side == null) {
            return;
        }
        boolean collecting = event.getBlocks().matches("collect", side);
        ArrayList<Tuple2<ItemInfo, Integer>> items = new ArrayList<Tuple2<ItemInfo, Integer>>();
        for (String data : RegexUtil.COMMA_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(event.getBlocks().getChangedSign(side).getLine(2)))) {
            int itemID = -1;
            int n = -1;
            int amount = -1;
            try {
                String[] splitLine = RegexUtil.COLON_PATTERN.split(RegexUtil.ASTERISK_PATTERN.split(data)[0]);
                itemID = Integer.parseInt(splitLine[0]);
                if (splitLine.length > 1) {
                    n = Short.parseShort(splitLine[1]);
                }
                try {
                    amount = Integer.parseInt(RegexUtil.ASTERISK_PATTERN.split(data)[1]);
                }
                catch (Exception exception) {}
            }
            catch (Exception ignored) {
                continue;
            }
            items.add(new Tuple2<ItemInfo, Integer>(new ItemInfo(itemID, n), amount));
        }
        Inventory cartinventory = ((StorageMinecart)event.getMinecart()).getInventory();
        ArrayList leftovers = new ArrayList();
        ArrayList<BlockInventoryHolder> containers = new ArrayList<BlockInventoryHolder>(RailUtil.getNearbyInventoryBlocks(event.getBlocks()));
        if (containers.isEmpty()) {
            return;
        }
        if (collecting) {
            ArrayList<Object> transferItems = new ArrayList<Object>();
            if (!items.isEmpty()) {
                for (ItemStack item : cartinventory.getContents()) {
                    if (!ItemUtil.isStackValid(item)) continue;
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        Tuple2 inf = (Tuple2)iter.next();
                        if (((ItemInfo)inf.left()).isTypeValid() && ((ItemInfo)inf.left()).getType() != item.getType() || ((ItemInfo)inf.left()).getData() >= 0 && ((ItemInfo)inf.left()).getData() != item.getDurability()) continue;
                        if ((Integer)inf.right() < 0) {
                            transferItems.add(item.clone());
                            cartinventory.remove(item);
                            continue;
                        }
                        ItemStack stack = item.clone();
                        if (item.getAmount() > (Integer)inf.right()) {
                            stack.setAmount(((Integer)inf.right()).intValue());
                            iter.remove();
                            items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.left(), 0));
                        } else {
                            iter.remove();
                            items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.left(), (Integer)inf.right() - stack.getAmount()));
                        }
                        transferItems.add(stack.clone());
                        cartinventory.removeItem(new ItemStack[]{stack});
                    }
                }
            } else {
                transferItems.addAll(Arrays.asList(cartinventory.getContents()));
                cartinventory.clear();
            }
            transferItems.removeAll(Collections.singleton(null));
            if (transferItems.isEmpty()) {
                return;
            }
            CraftBookPlugin.logDebugMessage("collecting " + transferItems.size() + " item stacks", "cart-deposit.collect");
            for (ItemStack itemStack : transferItems) {
                CraftBookPlugin.logDebugMessage("collecting " + itemStack.getAmount() + " items of type " + itemStack.getType().toString(), "cart-deposit.collect");
            }
            for (BlockInventoryHolder blockInventoryHolder : containers) {
                if (transferItems.isEmpty()) break;
                Inventory containerinventory = blockInventoryHolder.getInventory();
                leftovers.addAll(containerinventory.addItem(transferItems.toArray(new ItemStack[transferItems.size()])).values());
                transferItems.clear();
                transferItems.addAll(leftovers);
                leftovers.clear();
            }
            CraftBookPlugin.logDebugMessage("collected items. " + transferItems.size() + " stacks left over.", "cart-deposit.collect");
            leftovers.addAll(cartinventory.addItem(transferItems.toArray(new ItemStack[transferItems.size()])).values());
            transferItems.clear();
            transferItems.addAll(leftovers);
            leftovers.clear();
            CraftBookPlugin.logDebugMessage("collection done. " + transferItems.size() + " stacks wouldn't fit back.", "cart-deposit.collect");
        } else {
            ArrayList<Object> transferitems = new ArrayList<Object>();
            for (BlockInventoryHolder blockInventoryHolder : containers) {
                Inventory containerinventory = blockInventoryHolder.getInventory();
                if (!items.isEmpty()) {
                    for (ItemStack item : containerinventory.getContents()) {
                        if (!ItemUtil.isStackValid(item)) continue;
                        Iterator iter = items.iterator();
                        while (iter.hasNext()) {
                            Tuple2 inf = (Tuple2)iter.next();
                            if (((ItemInfo)inf.left()).isTypeValid() && ((ItemInfo)inf.left()).getType() != item.getType() || ((ItemInfo)inf.left()).getData() >= 0 && ((ItemInfo)inf.left()).getData() != item.getDurability()) continue;
                            if ((Integer)inf.right() < 0) {
                                transferitems.add(item.clone());
                                containerinventory.remove(item);
                                continue;
                            }
                            ItemStack stack = item.clone();
                            if (item.getAmount() > (Integer)inf.right()) {
                                stack.setAmount(((Integer)inf.right()).intValue());
                                iter.remove();
                                items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.left(), 0));
                            } else {
                                iter.remove();
                                items.add(new Tuple2<ItemInfo, Integer>((ItemInfo)inf.left(), (Integer)inf.right() - stack.getAmount()));
                            }
                            transferitems.add(stack.clone());
                            containerinventory.removeItem(new ItemStack[]{stack});
                        }
                    }
                    continue;
                }
                transferitems.addAll(Arrays.asList(containerinventory.getContents()));
                containerinventory.clear();
            }
            transferitems.removeAll(Collections.singleton(null));
            if (transferitems.isEmpty()) {
                return;
            }
            CraftBookPlugin.logDebugMessage("depositing " + transferitems.size() + " stacks", "cart-deposit.deposit");
            for (ItemStack itemStack : transferitems) {
                CraftBookPlugin.logDebugMessage("depositing " + itemStack.getAmount() + " items oftype " + itemStack.getType().toString(), "cart-deposit.deposit");
            }
            leftovers.addAll(cartinventory.addItem(transferitems.toArray(new ItemStack[transferitems.size()])).values());
            transferitems.clear();
            transferitems.addAll(leftovers);
            leftovers.clear();
            CraftBookPlugin.logDebugMessage("deposited, " + transferitems.size() + " items left over.", "cart-deposit.deposit");
            for (BlockInventoryHolder blockInventoryHolder : containers) {
                if (transferitems.isEmpty()) break;
                Inventory containerinventory = blockInventoryHolder.getInventory();
                leftovers.addAll(containerinventory.addItem(transferitems.toArray(new ItemStack[transferitems.size()])).values());
                containerinventory.clear();
                for (ItemStack item : leftovers) {
                    containerinventory.addItem(new ItemStack[]{item});
                }
                transferitems.clear();
                transferitems.addAll(leftovers);
                leftovers.clear();
            }
            CraftBookPlugin.logDebugMessage("deposit done. " + transferitems.size() + " items wouldn't fit back.", "cart-deposit.deposit");
        }
    }

    @Override
    public List<String> getApplicableSigns() {
        return List.of("Collect", "Deposit");
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("block", "Sets the block that is the base of the deposit mechanic.");
        this.setBlock(BlockParser.getBlock(config.getString("block", BlockTypes.IRON_ORE.id()), true));
    }
}

