/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart.blocks;

import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.RedstoneUtil;

public abstract class CartBlockMechanism
extends AbstractCraftBookMechanic
implements Listener {
    private BaseBlock block;
    private static final BlockFace[] powerSupplyOptions = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public CartBlockMechanism(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public BaseBlock getBlock() {
        return this.block;
    }

    public void setBlock(BaseBlock block) {
        this.block = block;
    }

    public static RedstoneUtil.Power isActive(CartMechanismBlocks blocks) {
        boolean isWired = false;
        if (blocks.hasSign()) {
            switch (CartBlockMechanism.isActive(blocks.sign())) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                default: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        if (blocks.hasBase()) {
            switch (CartBlockMechanism.isActive(blocks.base())) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                default: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        if (blocks.hasRail()) {
            switch (CartBlockMechanism.isActive(blocks.rail())) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                default: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        return isWired ? RedstoneUtil.Power.OFF : RedstoneUtil.Power.NA;
    }

    private static RedstoneUtil.Power isActive(Block block) {
        boolean isWired = false;
        block4: for (BlockFace face : powerSupplyOptions) {
            RedstoneUtil.Power p = RedstoneUtil.isPowered(block, face);
            switch (p) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                default: {
                    continue block4;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        return isWired ? RedstoneUtil.Power.OFF : RedstoneUtil.Power.NA;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (this.getApplicableSigns().isEmpty() || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        Block block = event.getBlock();
        net.kyori.adventure.text.Component[] lines = event.lines().toArray(new net.kyori.adventure.text.Component[0]);
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        try {
            boolean found = false;
            String lineFound = null;
            for (String sign : this.getApplicableSigns()) {
                if (!PlainTextComponentSerializer.plainText().serialize(lines[1]).equalsIgnoreCase("[" + sign + "]")) continue;
                found = true;
                lineFound = sign;
                break;
            }
            if (!found) {
                return;
            }
            if (!this.verify(BukkitChangedSign.create(event.getBlock(), event.getSide(), lines, player), player)) {
                block.breakNaturally();
                event.setCancelled(true);
                return;
            }
            player.checkPermission("craftbook." + this.getNodeId() + ".create");
            event.line(1, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)("[" + lineFound + "]")));
            player.printInfo((Component)TranslatableComponent.of((String)("craftbook." + this.getNodeId() + ".create")));
        }
        catch (AuthorizationException e) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            block.breakNaturally();
            event.setCancelled(true);
        }
    }

    @Override
    public String getDocsUrl(MechanicType<? extends CraftBookMechanic> mechanicType) {
        return CraftBook.getDocsDomain() + "mechanics/minecart/block/" + mechanicType.id() + "/";
    }

    protected String getNodeId() {
        return this.getMechanicType().id().replace("_", "").toLowerCase(Locale.ENGLISH);
    }

    public List<String> getApplicableSigns() {
        return List.of();
    }

    public boolean verify(BukkitChangedSign sign, CraftBookPlayer player) {
        return true;
    }
}

