/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class MoreRails
extends AbstractCraftBookMechanic {
    public boolean ladder;
    protected double ladderVerticalVelocity;
    public boolean pressurePlate;

    public MoreRails(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public boolean isValidRail(BlockType blockType) {
        return this.ladder && (blockType == BlockTypes.LADDER || blockType == BlockTypes.VINE) || this.pressurePlate && BlockCategories.PRESSURE_PLATES.contains((Keyed)blockType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("pressure-plate-intersection", "Allows use of pressure plates as rail intersections.");
        this.pressurePlate = config.getBoolean("pressure-plate-intersection", true);
        config.setComment("ladder-vertical-rail", "Allows use of ladders and vines as a vertical rail.");
        this.ladder = config.getBoolean("ladder-vertical-rail", true);
        config.setComment("ladder-vertical-rail-velocity", "Sets the velocity applied to the minecart on vertical rails.");
        this.ladderVerticalVelocity = config.getDouble("ladder-vertical-rail-velocity", 0.1);
    }
}

