/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.minecart;

import com.sk89q.util.yaml.YAMLProcessor;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class MinecartPhysicsControl
extends AbstractCraftBookMechanic {
    public boolean slowWhenEmpty;
    public double verticalFallSpeed;
    public double horizontalFallSpeed;
    public double maxSpeed;
    public double offRailSpeed;

    public MinecartPhysicsControl(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("slow-when-empty", "Whether Minecarts should slow faster when empty");
        this.slowWhenEmpty = config.getBoolean("slow-when-empty", true);
        config.setComment("vertical-fall-speed", "Sets the vertical fall speed of the minecart");
        this.verticalFallSpeed = config.getDouble("vertical-fall-speed", -1.0);
        config.setComment("horizontal-fall-speed", "Sets the horizontal fall speed of the minecart");
        this.horizontalFallSpeed = config.getDouble("horizontal-fall-speed", -1.0);
        config.setComment("max-speed", "Sets the max speed modifier of carts. Normal Minecraft speed is 0.4");
        this.maxSpeed = config.getDouble("max-speed", -1.0);
        config.setComment("off-rail-speed", "Sets the off-rail speed modifier of carts");
        this.offRailSpeed = config.getDouble("off-rail-speed", -1.0);
    }
}

