/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.entity.Player;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.items.ClickType;
import org.enginehub.craftbook.mechanics.items.CommandItemAction;
import org.enginehub.craftbook.mechanics.items.CommandItemCommands;
import org.enginehub.craftbook.mechanics.items.CommandItemDefinition;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.ParsingUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.Tuple2;

public class CommandItems
extends AbstractCraftBookMechanic
implements Listener {
    public static CommandItems INSTANCE;
    private YAMLProcessor config;
    private Set<CommandItemDefinition> definitions;
    private Map<Tuple2<String, String>, Integer> cooldownPeriods;
    private Map<UUID, List<ItemStack>> deathPersistItems = Maps.newHashMap();
    private boolean doChat = false;

    public CommandItems(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public CommandItemDefinition getDefinitionByName(String name) {
        for (CommandItemDefinition def : this.definitions) {
            if (!def.name.equalsIgnoreCase(name)) continue;
            return def;
        }
        return null;
    }

    @Override
    public void disable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("commanditems");
        registrar.unregisterTopLevel("comitems");
        this.definitions = null;
        this.cooldownPeriods = null;
        this.config = null;
        INSTANCE = null;
    }

    @Override
    public void enable() throws MechanicInitializationException {
        INSTANCE = this;
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("commanditems", Lists.newArrayList((Object[])new String[]{"comitems"}), "CraftBook CommandItems Commands", CommandItemCommands::register);
        this.definitions = new HashSet<CommandItemDefinition>();
        this.cooldownPeriods = new HashMap<Tuple2<String, String>, Integer>();
        CraftBookPlugin.inst().createDefaultConfiguration("command-items.yml");
        this.config = new YAMLProcessor(new File(CraftBookPlugin.inst().getDataFolder(), "command-items.yml"), false, YAMLFormat.EXTENDED);
        try {
            this.config.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int amount = 0;
        for (String key : this.config.getKeys("command-items")) {
            CommandItemDefinition comdef = CommandItemDefinition.load(this.config, "command-items." + key);
            if (this.addDefinition(comdef)) {
                CraftBookPlugin.logDebugMessage("Added CommandItem: " + key, "command-items.initialize");
                ++amount;
                if (comdef.type != CommandItemDefinition.CommandType.SUPERUSER || "true".equals(System.getProperty("craftbook.ignore-superuser-warning"))) continue;
                CraftBook.LOGGER.warn("Type `SUPERUSER` in use for CommandItem " + comdef.name + ". This is not recommended due to safety and performance issues with Spigot and the way permission plugins work. This will be removed in the future. Try to migrate to `CONSOLE`. Set property craftbook.ignore-superuser-warning to true to hide this message.");
                continue;
            }
            CraftBook.LOGGER.warn("Failed to add CommandItem: " + key);
        }
        this.config.save();
        CraftBook.LOGGER.info("Successfully added " + amount + " CommandItems!");
        if (this.definitions.size() > 0) {
            Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), () -> {
                Iterator<Map.Entry<Tuple2<String, String>, Integer>> iterator = this.cooldownPeriods.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Tuple2<String, String>, Integer> entry = iterator.next();
                    if (entry.getValue() > 1) {
                        this.cooldownPeriods.put(entry.getKey(), entry.getValue() - 1);
                        continue;
                    }
                    iterator.remove();
                }
            }, 0L, 20L);
            Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), () -> {
                for (org.bukkit.entity.Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getInventory().getItemInMainHand().getType() != Material.AIR) {
                        this.performCommandItems(player.getInventory().getItemInMainHand(), player, null);
                    }
                    if (player.getInventory().getItemInOffHand().getType() != Material.AIR) {
                        this.performCommandItems(player.getInventory().getItemInOffHand(), player, null);
                    }
                    for (ItemStack stack : player.getInventory().getArmorContents()) {
                        if (stack == null || stack.getType() == Material.AIR) continue;
                        this.performCommandItems(stack, player, null);
                    }
                }
            }, 10L, 10L);
        }
        this.doChat = this.definitions.stream().anyMatch(def -> def.clickType == ClickType.PLAYER_CHAT);
    }

    public boolean addDefinition(CommandItemDefinition def) {
        return this.definitions.add(def);
    }

    public void save() {
        this.config.addNode("command-items");
        for (CommandItemDefinition def : this.definitions) {
            this.config.addNode("command-items." + def.name);
            def.save(this.config, "command-items." + def.name);
        }
        this.config.save();
        this.disable();
        try {
            this.enable();
        }
        catch (MechanicInitializationException e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() == null) {
            return;
        }
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        this.performCommandItems(event.getItem(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerHitEntity(PlayerInteractEntityEvent event) {
        if (event.getPlayer().getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        this.performCommandItems(event.getPlayer().getInventory().getItemInMainHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageEntity(EntityDamageByEntityEvent event) {
        org.bukkit.entity.Player p;
        if (event.getDamager() instanceof Projectile) {
            if (!(((Projectile)event.getDamager()).getShooter() instanceof org.bukkit.entity.Player)) {
                return;
            }
            p = (org.bukkit.entity.Player)((Projectile)event.getDamager()).getShooter();
        } else {
            if (!(event.getDamager() instanceof org.bukkit.entity.Player)) {
                return;
            }
            p = (org.bukkit.entity.Player)event.getDamager();
        }
        if (p.getItemInHand() == null) {
            return;
        }
        this.performCommandItems(p.getItemInHand(), p, (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getPlayer().getItemInHand() == null) {
            return;
        }
        this.performCommandItems(event.getPlayer().getItemInHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!(event.getEntity().getShooter() instanceof org.bukkit.entity.Player)) {
            return;
        }
        if (((org.bukkit.entity.Player)event.getEntity().getShooter()).getItemInHand() == null) {
            return;
        }
        ItemStack item = ((org.bukkit.entity.Player)event.getEntity().getShooter()).getItemInHand();
        org.bukkit.entity.Player shooter = (org.bukkit.entity.Player)event.getEntity().getShooter();
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.performCommandItems(item, shooter, (Event)event), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity().getShooter() instanceof org.bukkit.entity.Player)) {
            return;
        }
        if (((org.bukkit.entity.Player)event.getEntity().getShooter()).getItemInHand() == null) {
            return;
        }
        ItemStack item = ((org.bukkit.entity.Player)event.getEntity().getShooter()).getItemInHand();
        org.bukkit.entity.Player shooter = (org.bukkit.entity.Player)event.getEntity().getShooter();
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.performCommandItems(item, shooter, (Event)event), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getItemInHand() == null) {
            return;
        }
        this.performCommandItems(event.getItemInHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem() == null) {
            return;
        }
        this.performCommandItems(event.getItem(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (event.getItemDrop() == null || !ItemUtil.isStackValid(event.getItemDrop().getItemStack())) {
            return;
        }
        this.performCommandItems(event.getItemDrop().getItemStack(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemBreak(PlayerItemBreakEvent event) {
        if (event.getBrokenItem() == null) {
            return;
        }
        this.performCommandItems(event.getBrokenItem(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getItem() == null) {
            return;
        }
        if (event.getEntity() instanceof org.bukkit.entity.Player) {
            this.performCommandItems(event.getItem().getItemStack(), (org.bukkit.entity.Player)event.getEntity(), (Event)event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Iterator stackIt = event.getDrops().iterator();
        block0: while (stackIt.hasNext()) {
            ItemStack stack = (ItemStack)stackIt.next();
            this.performCommandItems(stack, event.getEntity(), (Event)event);
            for (CommandItemDefinition def : this.definitions) {
                if (!ItemUtil.areItemsIdentical(stack, def.getItem()) || !def.keepOnDeath) continue;
                ArrayList items = this.deathPersistItems.get(event.getEntity().getUniqueId());
                if (items == null) {
                    items = Lists.newArrayList();
                }
                items.add(stack);
                this.deathPersistItems.put(event.getEntity().getUniqueId(), items);
                stackIt.remove();
                continue block0;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerItemClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || !(event.getWhoClicked() instanceof org.bukkit.entity.Player)) {
            return;
        }
        this.performCommandItems(event.getCurrentItem(), (org.bukkit.entity.Player)event.getWhoClicked(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.doChat || event.getPlayer().getItemInHand() == null) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> this.performCommandItems(event.getPlayer().getItemInHand(), event.getPlayer(), (Event)event));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.deathPersistItems.containsKey(event.getPlayer().getUniqueId())) {
            return;
        }
        List<ItemStack> its = this.deathPersistItems.get(event.getPlayer().getUniqueId());
        for (ItemStack it : its) {
            event.getPlayer().getInventory().addItem(new ItemStack[]{it});
        }
        this.deathPersistItems.remove(event.getPlayer().getUniqueId());
    }

    public void performCommandItems(ItemStack item, org.bukkit.entity.Player player, Event event) {
        if (event != null && !EventUtil.passesFilter(event)) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(player);
        block4: for (CommandItemDefinition def : this.definitions) {
            if (!ItemUtil.areItemsIdentical(def.stack, item)) continue;
            CommandItemDefinition comdef = def;
            if (!comdef.clickType.doesPassType(event) || !comdef.requireSneaking.doesPass(lplayer.isSneaking())) continue;
            if (!lplayer.hasPermission("craftbook.mech.commanditems") || comdef.permNode != null && !comdef.permNode.isEmpty() && !lplayer.hasPermission(comdef.permNode)) {
                if (!CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) continue;
                lplayer.printError("mech.use-permission");
                continue;
            }
            if (event instanceof Cancellable && comdef.cancelAction) {
                ((Cancellable)event).setCancelled(true);
            }
            if (this.cooldownPeriods.containsKey(new Tuple2<String, String>(lplayer.getName(), comdef.name))) {
                if (def.clickType == ClickType.PASSIVE || def.cooldownMessage.isEmpty()) continue;
                lplayer.printError(lplayer.translate(def.cooldownMessage).replace("%time%", String.valueOf(this.cooldownPeriods.get(new Tuple2<String, String>(lplayer.getName(), comdef.name)))));
                continue;
            }
            for (CommandItemAction commandItemAction : comdef.actions) {
                if (commandItemAction.stage != CommandItemAction.ActionRunStage.BEFORE) continue;
                try {
                    if (commandItemAction.runAction(comdef, event, player)) continue;
                    continue block4;
                }
                catch (VariableException e) {
                    e.printStackTrace();
                }
            }
            if (!player.hasPermission("craftbook.mech.commanditems.bypassconsumables") && !player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                int amount;
                for (ItemStack itemStack : def.consumables) {
                    boolean found = false;
                    amount = 0;
                    for (ItemStack tStack : player.getInventory().getContents()) {
                        if (!ItemUtil.areItemsIdentical(itemStack, tStack) || (amount += tStack.getAmount()) < itemStack.getAmount()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (def.missingConsumableMessage.isEmpty()) continue block4;
                    lplayer.printError(lplayer.translate(def.missingConsumableMessage).replace("%item%", itemStack.getAmount() + " " + itemStack.getType().name()));
                    continue block4;
                }
                for (ItemStack itemStack : def.consumables) {
                    boolean found = false;
                    amount = itemStack.getAmount();
                    for (int i = 0; i < player.getInventory().getContents().length; ++i) {
                        ItemStack tStack = player.getInventory().getContents()[i];
                        if (!ItemUtil.areItemsIdentical(itemStack, tStack)) continue;
                        ItemStack toRemove = tStack.clone();
                        if (toRemove.getAmount() > amount) {
                            toRemove.setAmount(toRemove.getAmount() - amount);
                            player.getInventory().setItem(i, toRemove);
                            amount = 0;
                        } else {
                            amount -= toRemove.getAmount();
                            player.getInventory().setItem(i, null);
                        }
                        if (amount > 0) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    lplayer.printError("mech.command-items.out-of-sync");
                    continue block4;
                }
                if (def.consumeSelf) {
                    if (event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getHand() == EquipmentSlot.OFF_HAND || event instanceof BlockPlaceEvent && ((BlockPlaceEvent)event).getHand() == EquipmentSlot.OFF_HAND) {
                        if (player.getInventory().getItemInOffHand().getAmount() > 1) {
                            player.getInventory().getItemInOffHand().setAmount(player.getInventory().getItemInOffHand().getAmount() - 1);
                        } else {
                            player.getInventory().setItemInOffHand(null);
                        }
                    } else if (event instanceof EntityPickupItemEvent) {
                        ((EntityPickupItemEvent)event).getItem().remove();
                        ((EntityPickupItemEvent)event).setCancelled(true);
                    } else if (player.getInventory().getItemInMainHand().getAmount() > 1) {
                        player.getInventory().getItemInMainHand().setAmount(player.getInventory().getItemInMainHand().getAmount() - 1);
                    } else {
                        player.getInventory().setItemInMainHand(null);
                    }
                }
                player.updateInventory();
            }
            for (String string : comdef.commands) {
                CommandItems.doCommand(string, event, comdef, player);
            }
            for (CommandItemAction commandItemAction : comdef.actions) {
                if (commandItemAction.stage != CommandItemAction.ActionRunStage.AFTER) continue;
                try {
                    commandItemAction.runAction(comdef, event, player);
                }
                catch (VariableException e) {
                    e.printStackTrace();
                }
            }
            if (comdef.cooldown > 0 && !lplayer.hasPermission("craftbook.mech.commanditems.bypasscooldown")) {
                this.cooldownPeriods.put(new Tuple2<String, String>(lplayer.getName(), comdef.name), comdef.cooldown);
            }
            if (comdef.delayedCommands.length <= 0) continue;
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                for (String command : comdef.delayedCommands) {
                    CommandItems.doCommand(command, event, comdef, player);
                }
            }, (long)comdef.delay);
        }
    }

    public static void doCommand(String command, Event event, CommandItemDefinition comdef, org.bukkit.entity.Player player) {
        if (command == null || command.trim().isEmpty()) {
            return;
        }
        command = CommandItems.parseLine(command, event, player);
        if (comdef.type == CommandItemDefinition.CommandType.CONSOLE) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        } else if (comdef.type == CommandItemDefinition.CommandType.PLAYER) {
            if (comdef.fakeCommand) {
                ProtectionUtil.canSendCommand(player, command);
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
            }
        } else if (comdef.type == CommandItemDefinition.CommandType.SUPERUSER) {
            PermissionAttachment att = player.addAttachment((Plugin)CraftBookPlugin.inst());
            att.setPermission("*", true);
            boolean wasOp = player.isOp();
            if (!wasOp) {
                player.setOp(true);
            }
            if (comdef.fakeCommand) {
                ProtectionUtil.canSendCommand(player, command);
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
            }
            att.remove();
            if (!wasOp) {
                player.setOp(wasOp);
            }
        }
    }

    static String parseLine(String command, Event event, org.bukkit.entity.Player player) {
        if (command == null) {
            return null;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(player);
        if (event instanceof EntityDamageByEntityEvent) {
            command = command.replace("@d.x", String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getX()));
            command = command.replace("@d.y", String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getY()));
            command = command.replace("@d.z", String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getZ()));
            command = command.replace("@d.bx", String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getBlockX()));
            command = command.replace("@d.by", String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getBlockY()));
            command = command.replace("@d.bz", String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getBlockZ()));
            command = command.replace("@d.w", ((EntityDamageByEntityEvent)event).getEntity().getLocation().getWorld().getName());
            command = command.replace("@d.l", ((EntityDamageByEntityEvent)event).getEntity().getLocation().toString());
            command = command.replace("@d.u", ((EntityDamageByEntityEvent)event).getEntity().getUniqueId().toString());
            command = ((EntityDamageByEntityEvent)event).getEntity() instanceof org.bukkit.entity.Player ? command.replace("@d", ((EntityDamageByEntityEvent)event).getEntity().getName()) : command.replace("@d", ((EntityDamageByEntityEvent)event).getEntity().getType().name());
        }
        if (event instanceof PlayerInteractEntityEvent) {
            command = command.replace("@d.x", String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getX()));
            command = command.replace("@d.y", String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getY()));
            command = command.replace("@d.z", String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getZ()));
            command = command.replace("@d.bx", String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getBlockX()));
            command = command.replace("@d.by", String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getBlockY()));
            command = command.replace("@d.bz", String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getBlockZ()));
            command = command.replace("@d.w", ((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getWorld().getName());
            command = command.replace("@d.l", ((PlayerInteractEntityEvent)event).getRightClicked().getLocation().toString());
            command = command.replace("@d.u", ((PlayerInteractEntityEvent)event).getRightClicked().getUniqueId().toString());
            command = ((PlayerInteractEntityEvent)event).getRightClicked() instanceof org.bukkit.entity.Player ? command.replace("@d", ((PlayerInteractEntityEvent)event).getRightClicked().getName()) : command.replace("@d", ((PlayerInteractEntityEvent)event).getRightClicked().getType().name());
        }
        if (event instanceof BlockEvent) {
            command = command.replace("@b.x", String.valueOf(((BlockEvent)event).getBlock().getX()));
            command = command.replace("@b.y", String.valueOf(((BlockEvent)event).getBlock().getY()));
            command = command.replace("@b.z", String.valueOf(((BlockEvent)event).getBlock().getZ()));
            command = command.replace("@b.w", ((BlockEvent)event).getBlock().getLocation().getWorld().getName());
            command = command.replace("@b.l", ((BlockEvent)event).getBlock().getLocation().toString());
            command = command.replace("@b.d", String.valueOf(((BlockEvent)event).getBlock().getData()));
            command = command.replace("@b.t", ((BlockEvent)event).getBlock().getType().getKey().toString());
            command = command.replace("@b", ((BlockEvent)event).getBlock().getType().name());
        }
        if (event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getClickedBlock() != null) {
            command = command.replace("@b.x", String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getX()));
            command = command.replace("@b.y", String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getY()));
            command = command.replace("@b.z", String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getZ()));
            command = command.replace("@b.w", ((PlayerInteractEvent)event).getClickedBlock().getWorld().getName());
            command = command.replace("@b.l", ((PlayerInteractEvent)event).getClickedBlock().getLocation().toString());
            command = command.replace("@b.d", String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getData()));
            command = command.replace("@b.t", ((PlayerInteractEvent)event).getClickedBlock().getType().getKey().toString());
            command = command.replace("@b", ((PlayerInteractEvent)event).getClickedBlock().getType().name());
        }
        if (event instanceof EntityEvent && ((EntityEvent)event).getEntityType() != null && command.contains("@e")) {
            command = command.replace("@e.x", String.valueOf(((EntityEvent)event).getEntity().getLocation().getX()));
            command = command.replace("@e.y", String.valueOf(((EntityEvent)event).getEntity().getLocation().getY()));
            command = command.replace("@e.z", String.valueOf(((EntityEvent)event).getEntity().getLocation().getZ()));
            command = command.replace("@e.bx", String.valueOf(((EntityEvent)event).getEntity().getLocation().getBlockX()));
            command = command.replace("@e.by", String.valueOf(((EntityEvent)event).getEntity().getLocation().getBlockY()));
            command = command.replace("@e.bz", String.valueOf(((EntityEvent)event).getEntity().getLocation().getBlockZ()));
            command = command.replace("@e.w", ((EntityEvent)event).getEntity().getLocation().getWorld().getName());
            command = command.replace("@e.l", ((EntityEvent)event).getEntity().getLocation().toString());
            command = command.replace("@e.u", ((EntityEvent)event).getEntity().getUniqueId().toString());
            command = command.replace("@e", ((EntityEvent)event).getEntityType().getName());
        }
        if (event instanceof AsyncPlayerChatEvent && command.contains("@m")) {
            command = command.replace("@m", ((AsyncPlayerChatEvent)event).getMessage());
        }
        command = ParsingUtil.parseLine(command, (Player)localPlayer);
        return command;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
    }
}

