/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.items;

import com.sk89q.util.yaml.YAMLProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.mechanics.items.ClickType;
import org.enginehub.craftbook.mechanics.items.CommandItemAction;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.TernaryState;

public class CommandItemDefinition {
    protected String name;
    protected ItemStack stack;
    protected String permNode;
    protected CommandType type;
    protected ClickType clickType;
    protected boolean fakeCommand;
    protected String[] commands;
    protected String[] delayedCommands;
    protected int delay;
    protected int cooldown;
    protected boolean cancelAction;
    protected ItemStack[] consumables;
    protected boolean consumeSelf;
    protected TernaryState requireSneaking;
    protected boolean keepOnDeath;
    protected String missingConsumableMessage;
    protected String cooldownMessage;
    protected CommandItemAction[] actions;

    public ItemStack getItem() {
        return this.stack;
    }

    public String getName() {
        return this.name;
    }

    public CommandItemDefinition(String name, ItemStack stack, CommandType type, ClickType clickType, String permNode, String[] commands, int delay, String[] delayedCommands, int cooldown, boolean cancelAction, ItemStack[] consumables, boolean consumeSelf, TernaryState requireSneaking, boolean keepOnDeath, CommandItemAction[] actions, String missingConsumableMessage, String cooldownMessage, boolean fakeCommand) {
        this.name = name;
        this.stack = stack;
        this.type = type;
        this.permNode = permNode;
        this.commands = commands;
        this.delay = delay;
        this.delayedCommands = delayedCommands;
        this.cooldown = cooldown;
        this.clickType = clickType;
        this.cancelAction = cancelAction;
        this.consumables = consumables;
        this.consumeSelf = consumeSelf;
        this.requireSneaking = requireSneaking;
        this.keepOnDeath = keepOnDeath;
        this.actions = actions;
        this.missingConsumableMessage = missingConsumableMessage;
        this.cooldownMessage = cooldownMessage;
        this.fakeCommand = fakeCommand;
    }

    public static CommandItemDefinition load(YAMLProcessor config, String path) {
        String name = RegexUtil.PERIOD_PATTERN.split(path)[1];
        ItemStack stack = ItemSyntax.getItem(config.getString(path + ".item"));
        List commands = config.getStringList(path + ".commands", new ArrayList());
        String permNode = config.getString(path + ".permission-node", "");
        CommandType type = CommandType.valueOf(config.getString(path + ".run-as", "PLAYER").toUpperCase(Locale.ENGLISH));
        ClickType clickType = ClickType.valueOf(config.getString(path + ".click-type", "CLICK_RIGHT").toUpperCase(Locale.ENGLISH));
        int delay = config.getInt(path + ".delay", 0);
        List delayedCommands = new ArrayList();
        if (delay > 0) {
            delayedCommands = config.getStringList(path + ".delayed-commands", new ArrayList());
        }
        int cooldown = config.getInt(path + ".cooldown", 0);
        boolean cancelAction = config.getBoolean(path + ".cancel-action", true);
        ArrayList<ItemStack> consumables = new ArrayList<ItemStack>();
        try {
            for (String s : config.getStringList(path + ".consumed-items", new ArrayList())) {
                consumables.add(ItemUtil.makeItemValid(ItemSyntax.getItem(s)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean consumeSelf = config.getBoolean(path + ".consume-self", false);
        TernaryState requireSneaking = TernaryState.parseTernaryState(config.getString(path + ".require-sneaking-state", "either"));
        boolean keepOnDeath = config.getBoolean(path + ".keep-on-death", false);
        boolean fakeCommand = config.getBoolean(path + ".fake-command-compatibility", false);
        ArrayList<CommandItemAction> actionList = new ArrayList<CommandItemAction>();
        if (config.getKeys(path + ".actions") != null) {
            for (String ac : config.getKeys(path + ".actions")) {
                CommandItemAction.ActionType acType = CommandItemAction.ActionType.valueOf(config.getString(path + ".actions." + ac + ".type"));
                String acValue = config.getString(path + ".actions." + ac + ".value");
                CommandItemAction.ActionRunStage acStage = CommandItemAction.ActionRunStage.valueOf(config.getString(path + ".actions." + ac + ".run-stage"));
                actionList.add(new CommandItemAction(ac, acType, acValue, acStage));
            }
        }
        String missingConsumableMessage = config.getString(path + ".consumable-message", "mech.command-items.need");
        String cooldownMessage = config.getString(path + ".cooldown-message", "mech.command-items.wait");
        return new CommandItemDefinition(name, stack, type, clickType, permNode, commands.toArray(new String[commands.size()]), delay, delayedCommands.toArray(new String[delayedCommands.size()]), cooldown, cancelAction, consumables.toArray(new ItemStack[consumables.size()]), consumeSelf, requireSneaking, keepOnDeath, actionList.toArray(new CommandItemAction[actionList.size()]), missingConsumableMessage, cooldownMessage, fakeCommand);
    }

    public void save(YAMLProcessor config, String path) {
        config.setProperty(path + ".item", (Object)ItemSyntax.getStringFromItem(this.stack));
        config.setProperty(path + ".commands", (Object)this.commands);
        config.setProperty(path + ".permission-node", (Object)this.permNode);
        config.setProperty(path + ".run-as", (Object)this.type.name());
        config.setProperty(path + ".click-type", (Object)this.clickType.name());
        config.setProperty(path + ".delay", (Object)this.delay);
        if (this.delay > 0) {
            config.setProperty(path + ".delayed-commands", (Object)this.delayedCommands);
        }
        config.setProperty(path + ".cooldown", (Object)this.cooldown);
        config.setProperty(path + ".cancel-action", (Object)this.cancelAction);
        ArrayList<String> consumables = new ArrayList<String>();
        for (ItemStack itemStack : this.consumables) {
            consumables.add(ItemSyntax.getStringFromItem(itemStack));
        }
        config.setProperty(path + ".consumed-items", consumables);
        config.setProperty(path + ".consume-self", (Object)this.consumeSelf);
        config.setProperty(path + ".require-sneaking-state", (Object)this.requireSneaking.name());
        config.setProperty(path + ".keep-on-death", (Object)this.keepOnDeath);
        config.setProperty(path + ".fake-command-compatibility", (Object)this.fakeCommand);
        config.addNode(path + ".actions");
        for (CommandItemAction commandItemAction : this.actions) {
            config.addNode(path + ".actions." + commandItemAction.name);
            config.setProperty(path + ".actions." + commandItemAction.name + ".type", (Object)commandItemAction.type.name());
            config.setProperty(path + ".actions." + commandItemAction.name + ".value", (Object)commandItemAction.value);
            config.setProperty(path + ".actions." + commandItemAction.name + ".run-stage", (Object)commandItemAction.stage.name());
        }
        config.setProperty(path + ".consumable-message", (Object)this.missingConsumableMessage);
        config.setProperty(path + ".cooldown-message", (Object)this.cooldownMessage);
    }

    static enum CommandType {
        PLAYER,
        CONSOLE,
        SUPERUSER;

    }
}

