/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.items;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.World;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.items.CommandItemCommands;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class CommandItemCommandsRegistration
implements CommandRegistration<CommandItemCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Vector3> vector3_Key = Key.of(Vector3.class);
    private static final Key<World> world_Key = Key.of(World.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<CraftBookPlayer> craftBookPlayer_Key = Key.of(CraftBookPlayer.class);
    private CommandManager commandManager;
    private CommandItemCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument namePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.name"), (Component)TextComponent.of((String)"The commanditem to give")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag otherPlayerPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The player to target")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.otherPlayer")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag amountPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Amount to give")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.amount")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag silentPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Silence output")).build();
    private final CommandArgument locationPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.location"), (Component)TextComponent.of((String)"The location to spawn")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(vector3_Key)).build();
    private final ArgAcceptingCommandFlag worldPart = CommandParts.flag((char)'w', (Component)TextComponent.of((String)"The world")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.world")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(world_Key)).build();

    private CommandItemCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static CommandItemCommandsRegistration builder() {
        return new CommandItemCommandsRegistration();
    }

    public CommandItemCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public CommandItemCommandsRegistration containerInstance(CommandItemCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public CommandItemCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public CommandItemCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("give", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Gives the player the item."));
            b.parts((Collection)ImmutableList.of((Object)this.namePart, (Object)this.otherPlayerPart, (Object)this.amountPart, (Object)this.silentPart));
            b.action(this::cmd$give);
        });
        this.commandManager.register("spawn", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Spawns the item at the coordinates"));
            b.parts((Collection)ImmutableList.of((Object)this.namePart, (Object)this.locationPart, (Object)this.worldPart, (Object)this.amountPart, (Object)this.silentPart));
            b.action(this::cmd$spawn);
        });
        this.commandManager.register("create", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"add"));
            b.description((Component)TextComponent.of((String)"Create a new CommandItem."));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$create);
            Method commandMethod = RegistrationUtil.getCommandMethod(CommandItemCommands.class, (String)"create", (Class[])new Class[]{CraftBookPlayer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$give(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(CommandItemCommands.class, (String)"giveItem", (Class[])new Class[]{Actor.class, String.class, String.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.giveItem(this.extract$actor(parameters), this.extract$name(parameters), this.extract$otherPlayer(parameters), this.extract$amount(parameters), this.extract$silent(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$spawn(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(CommandItemCommands.class, (String)"spawnItem", (Class[])new Class[]{Actor.class, String.class, Vector3.class, World.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.spawnItem(this.extract$actor(parameters), this.extract$name(parameters), this.extract$location(parameters), this.extract$world(parameters), this.extract$amount(parameters), this.extract$silent(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$create(CommandParameters parameters) throws CraftBookException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(CommandItemCommands.class, (String)"create", (Class[])new Class[]{CraftBookPlayer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.create(this.extract$player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private String extract$name(CommandParameters parameters) {
        return (String)this.namePart.value(parameters).asSingle(string_Key);
    }

    private String extract$otherPlayer(CommandParameters parameters) {
        return (String)this.otherPlayerPart.value(parameters).asSingle(string_Key);
    }

    private int extract$amount(CommandParameters parameters) {
        return (Integer)this.amountPart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$silent(CommandParameters parameters) {
        return this.silentPart.in(parameters);
    }

    private Vector3 extract$location(CommandParameters parameters) {
        return (Vector3)this.locationPart.value(parameters).asSingle(vector3_Key);
    }

    private World extract$world(CommandParameters parameters) {
        return (World)this.worldPart.value(parameters).asSingle(world_Key);
    }

    private CraftBookPlayer extract$player(CommandParameters parameters) {
        return (CraftBookPlayer)RegistrationUtil.requireOptional(craftBookPlayer_Key, (String)"player", (Optional)parameters.injectedValue(craftBookPlayer_Key));
    }
}

