/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.items;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.conversations.BooleanPrompt;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.MessagePrompt;
import org.bukkit.conversations.NullConversationPrefix;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitCraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanics.items.ClickType;
import org.enginehub.craftbook.mechanics.items.CommandItemAction;
import org.enginehub.craftbook.mechanics.items.CommandItemCommandsRegistration;
import org.enginehub.craftbook.mechanics.items.CommandItemDefinition;
import org.enginehub.craftbook.mechanics.items.CommandItems;
import org.enginehub.craftbook.util.EnumUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.TernaryState;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class CommandItemCommands {
    private ConversationFactory conversationFactory;

    public static void register(CommandManager commandManager, CommandRegistrationHandler registration) {
        registration.register(commandManager, (CommandRegistration)CommandItemCommandsRegistration.builder(), (Object)new CommandItemCommands());
    }

    public CommandItemCommands() {
        this.setupAddCommand(CraftBookPlugin.inst());
    }

    @Command(name="give", desc="Gives the player the item.")
    public void giveItem(Actor actor, @Arg(desc="The commanditem to give") String name, @ArgFlag(name=112, desc="The player to target") String otherPlayer, @ArgFlag(name=97, desc="Amount to give", def={"1"}) int amount, @Switch(name=115, desc="Silence output") boolean silent) throws CraftBookException, AuthorizationException {
        Player player;
        if (otherPlayer != null) {
            player = Bukkit.getPlayer((String)otherPlayer);
        } else {
            if (!(actor instanceof CraftBookPlayer)) {
                throw new CraftBookException("Please provide a player! (-p flag)");
            }
            player = ((BukkitCraftBookPlayer)actor).getPlayer();
        }
        if (player == null) {
            throw new CraftBookException("Unknown Player!");
        }
        if (!actor.hasPermission("craftbook.mech.commanditems.give" + (otherPlayer != null ? ".others" : "") + "." + name)) {
            throw new AuthorizationException();
        }
        CommandItemDefinition def = CommandItems.INSTANCE.getDefinitionByName(name);
        if (def == null) {
            throw new CraftBookException("Invalid CommandItem!");
        }
        ItemStack stack = ItemUtil.makeItemValid(def.getItem().clone());
        stack.setAmount(stack.getAmount() * amount);
        if (!player.getInventory().addItem(new ItemStack[]{stack}).isEmpty()) {
            throw new CraftBookException("Failed to add item to inventory!");
        }
        if (!silent) {
            actor.print("Gave CommandItem " + String.valueOf(ChatColor.BLUE) + def.getName() + String.valueOf(ChatColor.YELLOW) + " to " + player.getName());
        }
    }

    @Command(name="spawn", desc="Spawns the item at the coordinates")
    public void spawnItem(Actor actor, @Arg(desc="The commanditem to give") String name, @Arg(desc="The location to spawn") Vector3 location, @ArgFlag(name=119, desc="The world") org.bukkit.World world, @ArgFlag(name=97, desc="Amount to give", def={"1"}) int amount, @Switch(name=115, desc="Silence output") boolean silent) throws CraftBookException, AuthorizationException {
        if (!actor.hasPermission("craftbook.mech.commanditems.spawn" + name)) {
            throw new AuthorizationException();
        }
        CommandItemDefinition def = CommandItems.INSTANCE.getDefinitionByName(name);
        if (def == null) {
            throw new CraftBookException("Invalid CommandItem!");
        }
        if (world == null && actor instanceof CraftBookPlayer) {
            world = BukkitAdapter.adapt((World)((CraftBookPlayer)actor).getWorld());
        }
        if (world == null) {
            throw new CraftBookException("You must be a player or specify a valid world to use this command.");
        }
        ItemStack stack = def.getItem().clone();
        stack = ItemUtil.makeItemValid(stack);
        stack.setAmount(stack.getAmount() * amount);
        world.dropItem(new Location(world, location.x(), location.y(), location.z()), stack);
        if (!silent) {
            actor.print("Spawned CommandItem " + String.valueOf(ChatColor.BLUE) + def.getName() + String.valueOf(ChatColor.YELLOW) + " at " + location.toString() + " in " + world.getName());
        }
    }

    @Command(name="create", aliases={"add"}, desc="Create a new CommandItem.")
    @CommandPermissions(value={"craftbook.mech.commanditems.create"})
    public void create(CraftBookPlayer player) throws CraftBookException {
        Player bukkitPlayer = ((BukkitCraftBookPlayer)player).getPlayer();
        if (bukkitPlayer.getInventory().getItemInMainHand().getType() == Material.AIR) {
            throw new CraftBookException("Invalid Item for CommandItems!");
        }
        Conversation convo = this.conversationFactory.buildConversation((Conversable)bukkitPlayer);
        convo.getContext().setSessionData((Object)"item", (Object)bukkitPlayer.getInventory().getItemInHand());
        ArrayList<ItemStack> consumables = new ArrayList<ItemStack>();
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack;
            if (i == bukkitPlayer.getInventory().getHeldItemSlot() || !ItemUtil.isStackValid(stack = bukkitPlayer.getInventory().getItem(i))) continue;
            consumables.add(stack);
        }
        convo.getContext().setSessionData((Object)"consumables", consumables);
        convo.begin();
    }

    public void setupAddCommand(CraftBookPlugin plugin) {
        this.conversationFactory = new ConversationFactory((Plugin)plugin).withModality(true).withEscapeSequence("cancel").withPrefix((ConversationPrefix)new NullConversationPrefix()).withFirstPrompt((Prompt)new StringPrompt(this){

            public String getPromptText(ConversationContext context) {
                return String.valueOf(ChatColor.YELLOW) + "Please enter a unique ID for this CommandItem. (Used in /comitems give) (Type 'cancel' to quit)";
            }

            public Prompt acceptInput(ConversationContext context, String input) {
                if (input.trim().length() == 0) {
                    return Prompt.END_OF_CONVERSATION;
                }
                context.setSessionData((Object)"name", (Object)input);
                return new CommandPrompt();
            }
        });
    }

    private static class CreateItemPrompt
    extends MessagePrompt {
        private CreateItemPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            try {
                String name = (String)context.getSessionData((Object)"name");
                ItemStack stack = (ItemStack)context.getSessionData((Object)"item");
                List consumables = (List)context.getSessionData((Object)"consumables");
                List commands = (List)context.getSessionData((Object)"commands");
                String permNode = (String)context.getSessionData((Object)"permission-node");
                CommandItemDefinition.CommandType type = (CommandItemDefinition.CommandType)((Object)context.getSessionData((Object)"run-as"));
                ClickType clickType = (ClickType)((Object)context.getSessionData((Object)"click-type"));
                int delay = (Integer)context.getSessionData((Object)"delay");
                List delayedCommands = new ArrayList();
                if (delay > 0) {
                    delayedCommands = (List)context.getSessionData((Object)"delayed-commands");
                }
                int cooldown = (Integer)context.getSessionData((Object)"cooldown");
                boolean cancelAction = (Boolean)context.getSessionData((Object)"cancel-action");
                boolean consumeSelf = (Boolean)context.getSessionData((Object)"consume-self");
                TernaryState requireSneaking = (TernaryState)((Object)context.getSessionData((Object)"require-sneaking"));
                boolean keepOnDeath = (Boolean)context.getSessionData((Object)"keep-on-death");
                ArrayList actions = new ArrayList();
                String missingConsumableMessage = "mech.command-items.need";
                String cooldownMessage = "mech.command-items.wait";
                CommandItemDefinition def = new CommandItemDefinition(name, stack, type, clickType, permNode, commands.toArray(new String[commands.size()]), delay, delayedCommands.toArray(new String[delayedCommands.size()]), cooldown, cancelAction, consumables.toArray(new ItemStack[consumables.size()]), consumeSelf, requireSneaking, keepOnDeath, actions.toArray(new CommandItemAction[actions.size()]), missingConsumableMessage, cooldownMessage, false);
                CommandItems.INSTANCE.addDefinition(def);
                CommandItems.INSTANCE.save();
                return String.valueOf(ChatColor.YELLOW) + "Successfully added CommandItem: " + name;
            }
            catch (Exception e) {
                e.printStackTrace();
                return String.valueOf(ChatColor.RED) + "Failed to add CommandItem! See Console for more details!";
            }
        }

        protected Prompt getNextPrompt(ConversationContext context) {
            return Prompt.END_OF_CONVERSATION;
        }
    }

    private static class KeepOnDeathPrompt
    extends BooleanPrompt {
        private KeepOnDeathPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Do you wish the CommandItem to be kept on death?";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, boolean input) {
            context.setSessionData((Object)"keep-on-death", (Object)input);
            return new CreateItemPrompt();
        }
    }

    private static class DelayedCommandPrompt
    extends StringPrompt {
        private DelayedCommandPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter the commands you wish for this CommandItem to perform after the delay (Without the /). Please enter one per message. (Type 'done' to stop entering commands)";
        }

        public Prompt acceptInput(ConversationContext context, final String input) {
            if (input.trim().length() == 0 || input.trim().equalsIgnoreCase("done")) {
                return new KeepOnDeathPrompt();
            }
            if (context.getSessionData((Object)"delayed-commands") == null) {
                context.setSessionData((Object)"delayed-commands", (Object)new ArrayList<String>(){
                    {
                        this.add(input.trim());
                    }
                });
            } else {
                ArrayList list = (ArrayList)context.getSessionData((Object)"delayed-commands");
                list.add(input.trim());
                context.setSessionData((Object)"delayed-commands", (Object)list);
            }
            return new DelayedCommandPrompt();
        }
    }

    private static class DelayPrompt
    extends NumericPrompt {
        private DelayPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter a delay after which an extra set of Commands will be performed. (Useful for turning off CommandItems after a delay). (Type '0' for none)";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
            context.setSessionData((Object)"delay", (Object)input.intValue());
            if (input.intValue() == 0) {
                return new KeepOnDeathPrompt();
            }
            return new DelayedCommandPrompt();
        }
    }

    private static class RequireSneakingPrompt
    extends StringPrompt {
        private RequireSneakingPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "What sneaking state do you want players to require?";
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            context.setSessionData((Object)"require-sneaking", (Object)TernaryState.parseTernaryState(input));
            return new DelayPrompt();
        }
    }

    private static class ConsumeSelfPrompt
    extends BooleanPrompt {
        private ConsumeSelfPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Do you wish the CommandItem to be consumed when used?";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, boolean input) {
            context.setSessionData((Object)"consume-self", (Object)input);
            return new RequireSneakingPrompt();
        }
    }

    private static class CancelActionPrompt
    extends BooleanPrompt {
        private CancelActionPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Do you wish the action that is being performed to not occur when the CommandItem is used? (Eg, damaging entities)";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, boolean input) {
            context.setSessionData((Object)"cancel-action", (Object)input);
            return new ConsumeSelfPrompt();
        }
    }

    private static class CooldownPromp
    extends NumericPrompt {
        private CooldownPromp() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter the cooldown for using this CommandItem. (Type '0' for none)";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
            context.setSessionData((Object)"cooldown", (Object)input.intValue());
            return new CancelActionPrompt();
        }
    }

    private static class PermissionNodePromp
    extends StringPrompt {
        private PermissionNodePromp() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter the permission node you wish users to require to use the CommandItem. (Type 'none' for none.)";
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            if ((input = input.trim()).length() > 0 && !input.equalsIgnoreCase("none")) {
                context.setSessionData((Object)"permission-node", (Object)input);
            } else {
                context.setSessionData((Object)"permission-node", (Object)"");
            }
            return new CooldownPromp();
        }
    }

    private static class EventPrompt
    extends FixedSetPrompt {
        public EventPrompt() {
            super(EnumUtil.getStringArrayFromEnum(ClickType.class));
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter what event you want the CommandItem to be triggered by.";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, String input) {
            context.setSessionData((Object)"click-type", (Object)ClickType.valueOf(input));
            return new PermissionNodePromp();
        }
    }

    private static class RunAsPrompt
    extends FixedSetPrompt {
        public RunAsPrompt() {
            super(EnumUtil.getStringArrayFromEnum(CommandItemDefinition.CommandType.class));
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter what you would like the CommandItem to run as.";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, String input) {
            context.setSessionData((Object)"run-as", (Object)CommandItemDefinition.CommandType.valueOf(input));
            return new EventPrompt();
        }
    }

    private static class CommandPrompt
    extends StringPrompt {
        private CommandPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return String.valueOf(ChatColor.YELLOW) + "Please enter the commands you wish for this CommandItem to perform (Without the /). Please enter one per message. (Type 'done' to stop entering commands)";
        }

        public Prompt acceptInput(ConversationContext context, final String input) {
            if (input.trim().length() == 0 || input.trim().equalsIgnoreCase("done")) {
                if (context.getSessionData((Object)"commands") == null) {
                    context.setSessionData((Object)"commands", new ArrayList());
                }
                return new RunAsPrompt();
            }
            if (context.getSessionData((Object)"commands") == null) {
                context.setSessionData((Object)"commands", (Object)new ArrayList<String>(){
                    {
                        this.add(input.trim());
                    }
                });
            } else {
                ArrayList list = (ArrayList)context.getSessionData((Object)"commands");
                list.add(input.trim());
                context.setSessionData((Object)"commands", (Object)list);
            }
            return new CommandPrompt();
        }
    }
}

