/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.items;

import com.sk89q.worldedit.extension.platform.Actor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.gates.variables.NumericModifier;
import org.enginehub.craftbook.mechanics.items.CommandItemDefinition;
import org.enginehub.craftbook.mechanics.items.CommandItems;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.craftbook.util.RegexUtil;

public class CommandItemAction {
    protected String name;
    protected ActionType type;
    protected String value;
    ActionRunStage stage;

    public CommandItemAction(String name, ActionType type, String value, ActionRunStage stage) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.stage = stage;
    }

    public boolean runAction(CommandItemDefinition definition, Event event, Player player) throws VariableException {
        String newVal = CommandItems.parseLine(this.value, event, player);
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(player);
        switch (this.type.ordinal()) {
            case 0: {
                String[] svarParts = RegexUtil.EQUALS_PATTERN.split(newVal, 2);
                VariableKey sVariableKey = VariableKey.fromString(svarParts[0], (Actor)localPlayer);
                VariableManager.instance.setVariable(sVariableKey, svarParts[1]);
                return true;
            }
            case 1: {
                String[] mvarParts = RegexUtil.EQUALS_PATTERN.split(newVal, 2);
                VariableKey mVariableKey = VariableKey.fromString(mvarParts[0], (Actor)localPlayer);
                String[] mathFunctionParts = RegexUtil.COLON_PATTERN.split(mvarParts[1], 2);
                NumericModifier.MathFunction func = NumericModifier.MathFunction.parseFunction(mathFunctionParts[0]);
                String cur = VariableManager.instance.getVariable(mVariableKey);
                if (cur == null || cur.isEmpty()) {
                    cur = "0";
                }
                double currentValue = Double.parseDouble(cur);
                double amount = Double.parseDouble(mathFunctionParts[1]);
                String val = String.valueOf(currentValue = func.parseNumber(currentValue, amount));
                if (val.endsWith(".0")) {
                    val = val.replace(".0", "");
                }
                VariableManager.instance.setVariable(mVariableKey, val);
                return true;
            }
            case 2: {
                String[] isparts = RegexUtil.EQUALS_PATTERN.split(newVal, 2);
                VariableKey isVariableKey = VariableKey.fromString(isparts[0], (Actor)localPlayer);
                return VariableManager.instance.getVariable(isVariableKey).equals(isparts[1]);
            }
            case 3: {
                String[] isparts = RegexUtil.GREATER_THAN_PATTERN.split(newVal, 2);
                VariableKey isVariableKey = VariableKey.fromString(isparts[0], (Actor)localPlayer);
                double variable = 0.0;
                double test = 0.0;
                try {
                    variable = Double.parseDouble(VariableManager.instance.getVariable(isVariableKey));
                    test = Double.parseDouble(isparts[1]);
                }
                catch (NumberFormatException e) {
                    CraftBook.LOGGER.warn("Variable " + isparts[0] + " is not a number!");
                }
                return variable > test;
            }
            case 4: {
                String[] isparts = RegexUtil.LESS_THAN_PATTERN.split(newVal, 2);
                VariableKey isVariableKey = VariableKey.fromString(isparts[0], (Actor)localPlayer);
                double variable = 0.0;
                double test = 0.0;
                try {
                    variable = Double.parseDouble(VariableManager.instance.getVariable(isVariableKey));
                    test = Double.parseDouble(isparts[1]);
                }
                catch (NumberFormatException e) {
                    CraftBook.LOGGER.warn("Variable " + isparts[0] + " is not a number!");
                }
                return variable < test;
            }
        }
        return true;
    }

    static enum ActionType {
        SETVAR,
        MATHVAR,
        ISVAR,
        GREATERVAR,
        LESSVAR;

    }

    static enum ActionRunStage {
        BEFORE,
        AFTER;

    }
}

