/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.items;

import org.bukkit.Material;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;

public enum ClickType {
    CLICK_LEFT,
    CLICK_RIGHT,
    CLICK_EITHER,
    CLICK_LEFT_BLOCK,
    CLICK_RIGHT_BLOCK,
    CLICK_EITHER_BLOCK,
    CLICK_LEFT_AIR,
    CLICK_RIGHT_AIR,
    CLICK_EITHER_AIR,
    ENTITY_RIGHT,
    ENTITY_LEFT,
    ENTITY_ARROW,
    ENTITY_PROJECTILE,
    ENTITY_EITHER,
    BLOCK_BREAK,
    BLOCK_PLACE,
    BLOCK_PROJECTILE_AIR,
    BLOCK_PROJECTILE_BLOCK,
    BLOCK_PROJECTILE_EITHER,
    PROJECTILE_LAUNCH,
    BLOCK_EITHER,
    ITEM_CONSUME,
    ITEM_DROP,
    ITEM_BREAK,
    ITEM_PICKUP,
    ITEM_CLICK_LEFT,
    ITEM_CLICK_RIGHT,
    ITEM_CLICK_EITHER,
    PLAYER_DEATH,
    PLAYER_CHAT,
    PASSIVE,
    ANY;


    public boolean doesPassType(Event event) {
        switch (this.ordinal()) {
            case 31: {
                return true;
            }
            case 30: {
                return event == null;
            }
            case 14: {
                return event instanceof BlockBreakEvent;
            }
            case 15: {
                return event instanceof BlockPlaceEvent;
            }
            case 18: {
                return event instanceof ProjectileHitEvent;
            }
            case 16: {
                return event instanceof ProjectileHitEvent && ((ProjectileHitEvent)event).getEntity().getLocation().getBlock().getType() == Material.AIR;
            }
            case 17: {
                return event instanceof ProjectileHitEvent && ((ProjectileHitEvent)event).getEntity().getLocation().getBlock().getType() != Material.AIR;
            }
            case 20: {
                return event instanceof BlockBreakEvent || event instanceof BlockPlaceEvent;
            }
            case 2: {
                return event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getAction() != Action.PHYSICAL;
            }
            case 0: {
                return event instanceof PlayerInteractEvent && (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_AIR || ((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_BLOCK);
            }
            case 1: {
                return event instanceof PlayerInteractEvent && (((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_AIR || ((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_BLOCK);
            }
            case 5: {
                return event instanceof PlayerInteractEvent && (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_BLOCK || ((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_BLOCK);
            }
            case 3: {
                return event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_BLOCK;
            }
            case 4: {
                return event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_BLOCK;
            }
            case 8: {
                return event instanceof PlayerInteractEvent && (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_AIR || ((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_AIR);
            }
            case 6: {
                return event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_AIR;
            }
            case 7: {
                return event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_AIR;
            }
            case 11: 
            case 12: {
                return event instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)event).getDamager() instanceof Projectile;
            }
            case 19: {
                return event instanceof ProjectileLaunchEvent;
            }
            case 13: {
                return event instanceof PlayerInteractEntityEvent || event instanceof EntityDamageByEntityEvent;
            }
            case 10: {
                return event instanceof EntityDamageByEntityEvent;
            }
            case 9: {
                return event instanceof PlayerInteractEntityEvent;
            }
            case 23: {
                return event instanceof PlayerItemBreakEvent;
            }
            case 27: {
                return event instanceof InventoryClickEvent;
            }
            case 25: {
                return event instanceof InventoryClickEvent && ((InventoryClickEvent)event).getClick().isLeftClick();
            }
            case 26: {
                return event instanceof InventoryClickEvent && ((InventoryClickEvent)event).getClick().isRightClick();
            }
            case 21: {
                return event instanceof PlayerItemConsumeEvent;
            }
            case 22: {
                return event instanceof PlayerDropItemEvent;
            }
            case 24: {
                return event instanceof EntityPickupItemEvent;
            }
            case 29: {
                return event instanceof AsyncPlayerChatEvent;
            }
            case 28: {
                return event instanceof PlayerDeathEvent;
            }
        }
        return false;
    }
}

