/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.plc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.SelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.plc.CodeNotFoundException;
import org.enginehub.craftbook.mechanics.ic.plc.PlcException;
import org.enginehub.craftbook.mechanics.ic.plc.PlcLanguage;
import org.enginehub.craftbook.util.SignUtil;

class PlcIC<StateT, CodeT, Lang extends PlcLanguage<StateT, CodeT>>
implements IC {
    private static final Logger logger = Logger.getLogger("Minecraft.CraftBook");
    private static final int PLC_STORE_VERSION = 1;
    private Lang lang;
    private StateT state;
    private String codeString;
    private CodeT code;
    private BukkitChangedSign sign;
    private boolean error = false;
    private String errorString = "no error";

    PlcIC(BukkitChangedSign s, Lang l) throws ICVerificationException {
        this.sign = s;
        try {
            this.codeString = this.getCode();
        }
        catch (CodeNotFoundException e) {
            throw new ICVerificationException("Error retrieving code: " + e.getMessage());
        }
        l.compile(this.codeString);
    }

    public PlcIC(Server sv, BukkitChangedSign s, Lang l) {
        this.lang = l;
        this.sign = s;
        if (s == null) {
            return;
        }
        try {
            this.codeString = this.getCode();
        }
        catch (CodeNotFoundException e) {
            this.error("code missing", "Code went missing!!");
        }
        try {
            if (this.codeString != null) {
                this.code = this.lang.compile(this.codeString);
            }
        }
        catch (ICVerificationException e) {
            throw new RuntimeException("inconsistent compile check!", e);
        }
        this.state = this.lang.initState();
        this.tryLoadState();
    }

    private boolean isShared() {
        String line3 = PlainTextComponentSerializer.plainText().serialize(this.sign.getLine(3));
        return line3.startsWith("id:");
    }

    private String getID() {
        return PlainTextComponentSerializer.plainText().serialize(this.sign.getLine(2));
    }

    private String getFileName() {
        if (!this.isShared()) {
            return this.lang.getName() + "$$" + this.sign.getX() + "_" + this.sign.getY() + "_" + this.sign.getZ();
        }
        return this.lang.getName() + "$" + String.valueOf(this.sign.getLine(3));
    }

    private File getStorageLocation() {
        World w = this.sign.getBlock().getWorld();
        File worldDir = w.getWorldFolder();
        File targetDir = new File(new File(worldDir, "craftbook"), "plcs");
        if (new File(worldDir, "craftbook-plcs").exists()) {
            File oldFolder = new File(worldDir, "craftbook-plcs");
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            if (!oldFolder.renameTo(targetDir)) {
                logger.warning("Failed to copy PLC States over to new directory!");
            }
            oldFolder.delete();
        }
        targetDir.mkdirs();
        return new File(targetDir, this.getFileName());
    }

    private String hashCode(String code) {
        if (code == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(code.getBytes("UTF-8"));
            StringBuilder hex = new StringBuilder();
            for (byte aDigest : digest) {
                String byteHex = Integer.toHexString(aDigest & 0xFF);
                if (byteHex.length() == 1) {
                    hex.append("0");
                }
                hex.append(byteHex);
            }
            return hex.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException("insane JVM implementation", e);
        }
    }

    private void tryLoadState() {
        try {
            this.loadState();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to load PLC state", e);
            this.state = this.lang.initState();
            this.getStorageLocation().delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadState() throws IOException {
        if (!this.getStorageLocation().exists()) {
            return;
        }
        try (DataInputStream in = new DataInputStream(new FileInputStream(this.getStorageLocation()));){
            switch (in.readInt()) {
                case 1: {
                    this.error = in.readBoolean();
                    this.errorString = in.readUTF();
                }
                case 0: {
                    String langName = in.readUTF();
                    String id = in.readUTF();
                    String code = this.hashCode(in.readUTF());
                    if ((this.lang.getName().equals(langName) || this.lang.supports(langName)) && (this.isShared() || id.equals(this.getID()) && this.hashCode(this.codeString).equals(code))) {
                        this.lang.loadState(this.state, in);
                        return;
                    } else {
                        this.error = false;
                        this.errorString = "no error";
                        return;
                    }
                }
                default: {
                    throw new IOException("incompatible version");
                }
            }
        }
    }

    private void trySaveState() {
        try {
            this.saveState();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to save PLC state", e);
            this.state = this.lang.initState();
        }
    }

    private void saveState() throws IOException {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getStorageLocation()));){
            out.writeInt(1);
            out.writeBoolean(this.error);
            out.writeUTF(this.errorString);
            out.writeUTF(this.lang.getName());
            out.writeUTF(this.error ? "(error)" : this.getID());
            out.writeUTF(this.hashCode(this.codeString));
            this.lang.writeState(this.state, out);
        }
    }

    private String getBookCode(Block chestBlock) throws CodeNotFoundException {
        Chest c = (Chest)chestBlock.getState();
        Inventory i = c.getBlockInventory();
        ItemStack book = null;
        for (ItemStack s : i.getContents()) {
            if (s == null || s.getAmount() <= 0 || s.getType() != Material.WRITABLE_BOOK && s.getType() != Material.WRITTEN_BOOK) continue;
            if (book != null) {
                throw new CodeNotFoundException("More than one written book found in chest!!");
            }
            book = s;
        }
        if (book == null) {
            throw new CodeNotFoundException("No written books found in chest.");
        }
        StringBuilder code = new StringBuilder();
        for (String s : ((BookMeta)book.getItemMeta()).getPages()) {
            code.append(s).append('\n');
        }
        CraftBookPlugin.logDebugMessage(code.toString(), "plc");
        return code.toString();
    }

    private String getCode() throws CodeNotFoundException {
        Sign sign = this.sign.getSign();
        Block above = sign.getLocation().add(new Vector(0, 1, 0)).getBlock();
        if (above.getType() == Material.CHEST) {
            return this.getBookCode(above);
        }
        Block below = sign.getLocation().add(new Vector(0, -1, 0)).getBlock();
        if (below.getType() == Material.CHEST) {
            return this.getBookCode(below);
        }
        Location l = sign.getLocation();
        World w = l.getWorld();
        int x = l.getBlockX();
        int z = l.getBlockZ();
        for (int y = 0; y < w.getMaxHeight(); ++y) {
            if (y == l.getBlockY() || !SignUtil.isSign(w.getBlockAt(x, y, z))) continue;
            BukkitChangedSign s = BukkitChangedSign.create(w.getBlockAt(x, y, z), this.sign.getSide());
            if (!PlainTextComponentSerializer.plainText().serialize(s.getLine(1)).equalsIgnoreCase("[Code Block]")) continue;
            Block b = w.getBlockAt(x, --y, z);
            StringBuilder code = new StringBuilder();
            while (SignUtil.isSign(b)) {
                s = BukkitChangedSign.create(b, this.sign.getSide());
                for (int li = 0; li < 4 && y != l.getBlockY(); ++li) {
                    code.append(PlainTextComponentSerializer.plainText().serialize(s.getLine(li))).append('\n');
                }
                b = w.getBlockAt(x, --y, z);
            }
            return code.toString();
        }
        throw new CodeNotFoundException("No code source found.");
    }

    @Override
    public String getTitle() {
        return this.lang.getName() + " PLC";
    }

    @Override
    public String getSignTitle() {
        return this.lang.getName().toUpperCase(Locale.ENGLISH);
    }

    public void error(String shortMessage, String detailedMessage) {
        this.sign.setLine(2, Component.text((String)"!Error!").color((TextColor)NamedTextColor.RED));
        this.sign.setLine(3, (Component)Component.text((String)shortMessage));
        this.sign.update(false);
        this.error = true;
        this.errorString = detailedMessage;
        this.trySaveState();
    }

    @Override
    public void trigger(ChipState chip) {
        try {
            if (this.isShared()) {
                this.tryLoadState();
            }
            this.lang.execute(chip, this.state, this.code);
            this.trySaveState();
        }
        catch (PlcException e) {
            this.error(e.getMessage(), e.detailedMessage);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Internal error while executing PLC", e);
            this.error(e.getClass().getName(), "Internal error encountered: " + e.getClass().getName());
        }
    }

    public IC selfTriggered() {
        PlcIC self = this;
        return new SelfTriggeredPlcIC(self);
    }

    @Override
    public void onRightClick(Player p) {
        if (CraftBookPlugin.inst().hasPermission((CommandSender)p, "craftbook.plc.debug")) {
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "Programmable Logic Controller debug information");
            p.sendMessage(String.valueOf(ChatColor.RED) + "Status:" + String.valueOf(ChatColor.RESET) + " " + (this.error ? "Error Encountered" : "OK"));
            p.sendMessage(String.valueOf(ChatColor.RED) + "Location:" + String.valueOf(ChatColor.RESET) + " (" + this.sign.getX() + ", " + this.sign.getY() + ", " + this.sign.getZ() + ")");
            p.sendMessage(String.valueOf(ChatColor.RED) + "Language:" + String.valueOf(ChatColor.RESET) + " " + this.lang.getName());
            p.sendMessage(String.valueOf(ChatColor.RED) + "Full Storage Name:" + String.valueOf(ChatColor.RESET) + " " + this.getFileName());
            if (this.error) {
                p.sendMessage(this.errorString);
            } else {
                p.sendMessage(this.lang.dumpState(this.state));
            }
        } else {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You do not have the necessary permissions to do that.");
        }
    }

    @Override
    public void unload() {
    }

    @Override
    public void load() {
    }

    @Override
    public BukkitChangedSign getSign() {
        return this.sign;
    }

    @Override
    public void onICBreak(BlockBreakEvent event) {
    }

    private static class SelfTriggeredPlcIC
    implements SelfTriggeredIC {
        private final IC self;

        public SelfTriggeredPlcIC(IC self) {
            this.self = self;
        }

        @Override
        public String getTitle() {
            return this.self.getTitle();
        }

        @Override
        public String getSignTitle() {
            return this.self.getSignTitle();
        }

        @Override
        public void trigger(ChipState chip) {
        }

        @Override
        public void think(ChipState chip) {
            this.self.trigger(chip);
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void onRightClick(Player p) {
            this.self.onRightClick(p);
        }

        @Override
        public void unload() {
        }

        @Override
        public void load() {
        }

        @Override
        public boolean isAlwaysST() {
            return false;
        }

        @Override
        public BukkitChangedSign getSign() {
            return this.self.getSign();
        }

        @Override
        public void onICBreak(BlockBreakEvent event) {
        }
    }
}

