/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.plc;

import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.plc.PlcIC;
import org.enginehub.craftbook.mechanics.ic.plc.PlcLanguage;
import org.enginehub.craftbook.util.RegexUtil;

public class PlcFactory<StateT, CodeT, Lang extends PlcLanguage<StateT, CodeT>>
implements ICFactory {
    private Lang lang;
    private boolean selfTriggered;
    private Server s;
    private String id;

    public PlcFactory(Server s, Lang lang, boolean selfTriggered, String id) {
        this.s = s;
        this.lang = lang;
        this.selfTriggered = selfTriggered;
        this.id = id;
    }

    @Override
    public IC create(BukkitChangedSign sign) {
        PlcIC i = new PlcIC(this.s, sign, this.lang);
        return this.selfTriggered ? i.selfTriggered() : i;
    }

    @Override
    public void verify(BukkitChangedSign sign) throws ICVerificationException {
        new PlcIC(sign, this.lang);
        sign.setLine(2, (Component)Component.text((String)("id:" + ThreadLocalRandom.current().nextInt())));
        String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
        if (!line3.isEmpty() && !RegexUtil.PLC_NAME_PATTERN.matcher(line3).matches()) {
            throw new ICVerificationException("illegal storage name");
        }
        sign.update(false);
    }

    @Override
    public void checkPlayer(BukkitChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
    }

    public static <StateT, CodeT, Lang extends PlcLanguage<StateT, CodeT>> PlcFactory<StateT, CodeT, Lang> fromLang(Server s, Lang lang, boolean selfTriggered, String id) {
        return new PlcFactory<StateT, CodeT, Lang>(s, lang, selfTriggered, id);
    }

    @Override
    public String getShortDescription() {
        return "Programmable Logic Chip";
    }

    @Override
    public String[] getLineHelp() {
        return new String[]{"PLC ID", "Shared Access ID"};
    }

    @Override
    public String[] getLongDescription() {
        if (this.id.equalsIgnoreCase("MC5000")) {
            return new String[]{"The '''MC5000''' is a [[../Perlstone/]]-powered programmable logic chip. Because it is of the VIVO family, it has a variable number of inputs and outputs, giving you the choice of either 3-1 or 1-3 for the number of inputs and outputs, respectively.", "", "== Construction ==", "", "=== Sign Method ===", "Code for the MC5000 is to be put in signs anywhere above or below the IC sign. The top most sign must contain '''[Code Block]''' on the second line of the sign and code then starts on signs below, and ends on the first non-sign block, or the IC sign. No code goes on the actual IC sign. If multiple '''[Code Block]''' signs exist, the topmost one will be used. Code is to be written in [[../Perlstone/]].", "", "[[File:MC5000.png|center]]", "", "=== Book Method ===", "Alternatively, as of version 3.3, code for the MC5000 can be placed in a chest directly above or below the IC sign. There must only be one book in the chest. If there is both a chest above the IC, and one below it, only the one above it will be searched.", "", "[[File:Altmc5000.png|center]]", "", "== Execution ==", "", "The first three functions of the PerlStone code is called, and their return values are put into the respective outputs, if they exist. Note that they will be called even if the outputs do not exist."};
        }
        return new String[]{"Missing Description"};
    }

    @Override
    public String[] getPinDescription(ChipState state) {
        String[] pins = new String[state.getInputCount() + state.getOutputCount()];
        for (int i = 0; i < pins.length; ++i) {
            pins[i] = "Programmable Pin";
        }
        return pins;
    }

    @Override
    public void unload() {
    }

    @Override
    public void load() {
    }
}

