/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.weather;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.SearchArea;

public class WeatherFaker
extends AbstractSelfTriggeredIC {
    private Set<String> players;
    SearchArea area;
    boolean rain;

    public WeatherFaker(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Weather Faker";
    }

    @Override
    public String getSignTitle() {
        return "WEATHER FAKER";
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.area.isWithinArea(p.getLocation())) {
                    p.setPlayerWeather(this.rain ? WeatherType.DOWNFALL : WeatherType.CLEAR);
                    this.players.add(p.getName());
                    continue;
                }
                if (!this.players.contains(p.getName())) continue;
                this.players.remove(p.getName());
                p.resetPlayerWeather();
            }
        } else {
            for (String p : this.players) {
                Player pp = Bukkit.getPlayerExact((String)p);
                if (pp == null) continue;
                pp.resetPlayerWeather();
            }
            this.players.clear();
        }
    }

    @Override
    public void load() {
        this.players = new HashSet<String>();
        this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(2));
        this.rain = this.getLine(3).equals("rain");
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new WeatherFaker(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Fakes a players weather in radius.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius", "rain (If it should rain)"};
        }
    }
}

