/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.weather;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;

public class TimeSet
extends AbstractSelfTriggeredIC {
    long time;

    public TimeSet(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Time Set";
    }

    @Override
    public String getSignTitle() {
        return "TIME SET";
    }

    @Override
    public void load() {
        try {
            this.time = Long.parseLong(this.getLine(2));
        }
        catch (NumberFormatException ex) {
            this.time = -1L;
        }
    }

    @Override
    public void trigger(ChipState chip) {
        try {
            if (chip.getInput(0) && this.time >= 0L) {
                this.getSign().getBlock().getWorld().setTime(this.time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void think(ChipState chip) {
        try {
            if (chip.getInput(0) && this.time >= 0L) {
                this.getSign().getBlock().getWorld().setTime(this.time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new TimeSet(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Set time when triggered.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"time to set", null};
        }
    }
}

