/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.weather;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;

public class TimeControlAdvanced
extends AbstractIC {
    public TimeControlAdvanced(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Advanced Time Control";
    }

    @Override
    public String getSignTitle() {
        return "ADV TIME CONTROL";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.isTriggered(0) && chip.getInput(0)) {
            int time = chip.getInput(1) ? 24000 : 16000;
            this.getSign().getBlock().getWorld().setTime((long)time);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Day on Low, Night on High", "Nothing", "Nothing"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new TimeControlAdvanced(this.getServer(), sign, this);
        }
    }
}

