/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.ICUtil;

public class WaterSensor
extends AbstractSelfTriggeredIC {
    private Block center;

    public WaterSensor(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    @Override
    public String getTitle() {
        return "Water Sensor";
    }

    @Override
    public String getSignTitle() {
        return "WATER SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasWater());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.hasWater());
    }

    protected boolean hasWater() {
        return this.center.getType() == Material.WATER || this.center.getBlockData() instanceof Waterlogged && ((Waterlogged)this.center.getBlockData()).isWaterlogged();
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new WaterSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if water is at the given offset.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+ox:y:z offset", null};
        }
    }
}

