/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import org.bukkit.Server;
import org.bukkit.block.Block;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.ICUtil;

public class PowerSensor
extends AbstractSelfTriggeredIC {
    private Block center;

    public PowerSensor(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    @Override
    public String getTitle() {
        return "Power Sensor";
    }

    @Override
    public String getSignTitle() {
        return "POWER SENSOR";
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.isPowered());
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isPowered());
        }
    }

    protected boolean isPowered() {
        return this.center.isBlockPowered() || this.center.isBlockIndirectlyPowered();
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new PowerSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Detects if offset block is powered.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"x:y:z offset", null};
        }
    }
}

