/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.PlayerType;
import org.enginehub.craftbook.util.SearchArea;

public class PlayerSensor
extends AbstractSelfTriggeredIC {
    private static final Pattern NAME_STRIPPER = Pattern.compile("[gpnta!^]*:");
    private SearchArea area;
    private PlayerType type;
    private String nameLine;
    private boolean invertOutput = false;
    private boolean invertDetection = false;

    public PlayerSensor(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Player Detection";
    }

    @Override
    public String getSignTitle() {
        return "P-DETECTION";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.invertOutput != this.isDetected());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.invertOutput != this.isDetected());
    }

    @Override
    public void load() {
        this.type = this.getLine(3).contains(":") ? PlayerType.getFromChar(this.getLine(3).replace("!", "").replace("^", "").trim().toCharArray()[0]) : PlayerType.NAME;
        this.invertOutput = this.getLine(3).contains("!");
        this.invertDetection = this.getLine(3).contains("^");
        this.nameLine = NAME_STRIPPER.matcher(this.getLine(3)).replaceAll(Matcher.quoteReplacement("")).trim();
        this.area = SearchArea.createArea(this.getSign().getBlock(), this.getLine(2));
    }

    private boolean isDetected() {
        if (!this.nameLine.isEmpty() && this.type == PlayerType.NAME && !this.invertDetection) {
            Player p = Bukkit.getPlayerExact((String)this.nameLine);
            return p != null && this.area.isWithinArea(p.getLocation());
        }
        for (Player p : this.area.getPlayersInArea()) {
            if (p == null || !p.isValid()) continue;
            if (this.nameLine.isEmpty()) {
                return true;
            }
            if (this.invertDetection == this.type.doesPlayerPass(p, this.nameLine)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new PlayerSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            if (!SearchArea.createArea(sign.getBlock(), PlainTextComponentSerializer.plainText().serialize(sign.getLine(2))).isValid()) {
                throw new ICVerificationException("Invalid SearchArea on line 3!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Detects players within a radius.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"SearchArea", "PlayerType"};
        }
    }
}

