/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.worldedit.math.Vector3;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.EntityType;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.RegexUtil;

public class MovementSensor
extends AbstractSelfTriggeredIC {
    private Set<EntityType> types;
    private Block center;
    private Vector3 radius;

    public MovementSensor(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.types = EntityType.getDetected(this.getLine(3).trim());
        if (this.types.isEmpty()) {
            this.types.add(EntityType.ANY);
        }
        this.getSign().setLine(3, (Component)Component.text((String)this.getLine(3).toUpperCase(Locale.ENGLISH)));
        this.radius = ICUtil.parseRadius(this.getSign());
        Object radiusString = this.radius.x() + "," + this.radius.y() + "," + this.radius.z();
        if (this.radius.x() == this.radius.y() && this.radius.y() == this.radius.z()) {
            radiusString = String.valueOf(this.radius.x());
        }
        if (this.getLine(2).contains("=")) {
            this.getSign().setLine(2, (Component)Component.text((String)((String)radiusString + "=" + RegexUtil.EQUALS_PATTERN.split(this.getLine(2))[1])));
            this.center = ICUtil.parseBlockLocation(this.getSign());
        } else {
            this.getSign().setLine(2, (Component)Component.text((String)radiusString));
            this.center = this.getBackBlock();
        }
        this.getSign().update(false);
    }

    @Override
    public String getTitle() {
        return "Movement Sensor";
    }

    @Override
    public String getSignTitle() {
        return "MOVING SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.check());
        }
    }

    @Override
    public void think(ChipState chip) {
        this.check();
    }

    public boolean check() {
        block0: for (Entity entity : this.center.getLocation().getNearbyEntities(this.radius.x(), this.radius.y(), this.radius.z())) {
            if (!entity.isValid()) continue;
            for (EntityType type : this.types) {
                if (!type.is(entity)) continue;
                if (!LocationUtil.isWithinRadius(this.center.getLocation(), entity.getLocation(), this.radius) || !(entity.getVelocity().lengthSquared() >= 0.01)) continue block0;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new MovementSensor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if a nearby entity is moving.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius=x:y:z offset", "entity type"};
        }
    }
}

