/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.SignUtil;

public class LightSensor
extends AbstractSelfTriggeredIC {
    Location centre;
    byte min;

    public LightSensor(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Light Sensor";
    }

    @Override
    public String getSignTitle() {
        return "LIGHT SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasLight());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.hasLight());
    }

    @Override
    public void load() {
        this.centre = !this.getLine(3).isEmpty() ? ICUtil.parseBlockLocation(this.getSign(), 3).getLocation() : SignUtil.getBackBlock(this.getSign().getBlock()).getLocation().add(0.0, 1.0, 0.0);
        try {
            this.min = Byte.parseByte(this.getLine(2));
        }
        catch (Exception e) {
            this.min = (byte)10;
            try {
                this.getSign().setLine(2, (Component)Component.text((int)this.min));
                this.getSign().update(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean hasLight() {
        byte lightLevel = this.centre.getBlock().getLightLevel();
        return lightLevel >= this.min;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new LightSensor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if specific block is above specified light level.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"minimum light", "x:y:z offset"};
        }
    }
}

