/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import java.util.Collections;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.EntityType;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.SearchArea;

public class ItemSensor
extends AbstractSelfTriggeredIC {
    private ItemStack item;
    private SearchArea area;

    public ItemSensor(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.item = ItemSyntax.getItem(this.getLine(3));
        this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(2));
    }

    @Override
    public String getTitle() {
        return "Item Detection";
    }

    @Override
    public String getSignTitle() {
        return "ITEM DETECTION";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.isDetected());
    }

    protected boolean isDetected() {
        for (Entity entity : this.area.getEntitiesInArea(Collections.singleton(EntityType.ITEM))) {
            ItemStack itemStack = ((Item)entity).getItemStack();
            if (!ItemUtil.areItemsIdentical(itemStack, this.item)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ItemSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Detects items within a given radius";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"SearchArea", "id:data"};
        }
    }
}

