/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.SelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.gates.world.sensors.ItemSensor;
import org.enginehub.craftbook.util.ICUtil;

public class ItemNotSensor
extends ItemSensor
implements SelfTriggeredIC {
    public ItemNotSensor(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Item Not Sensor";
    }

    @Override
    public String getSignTitle() {
        return "ITEM NOT SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, !this.isDetected());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, !this.isDetected());
    }

    public static class Factory
    extends ItemSensor.Factory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ItemNotSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Detects if an item is NOT within a given radius";
        }
    }
}

