/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class DaySensor
extends AbstractSelfTriggeredIC {
    long day;
    long night;

    public DaySensor(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Day Sensor";
    }

    @Override
    public String getSignTitle() {
        return "DAY SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDay());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.isDay());
    }

    @Override
    public void load() {
        try {
            this.night = Long.parseLong(this.getLine(3));
        }
        catch (Exception ignored) {
            this.night = 13000L;
        }
        try {
            this.day = Long.parseLong(this.getLine(2));
        }
        catch (Exception ignored) {
            this.day = 0L;
        }
    }

    protected boolean isDay() {
        long time;
        for (time = this.getBackBlock().getWorld().getTime(); time < 0L; time += 24000L) {
        }
        while (time > 24000L) {
            time -= 24000L;
        }
        if (this.day < this.night) {
            return time >= this.day && time <= this.night;
        }
        if (this.day > this.night) {
            return time <= this.day || time >= this.night;
        }
        return time < this.night;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new DaySensor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if it is day.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"custom day start", "custom night start (day end)"};
        }
    }
}

