/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.RegexUtil;

public class BlockSensor
extends AbstractSelfTriggeredIC {
    private Block center;
    private BlockStateHolder item;

    public BlockSensor(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
        this.item = BlockParser.getBlock(this.getLine(3), true);
    }

    @Override
    public String getTitle() {
        return "Block Sensor";
    }

    @Override
    public String getSignTitle() {
        return "BLOCK SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, ((Factory)this.getFactory()).invert != this.hasBlock());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, ((Factory)this.getFactory()).invert != this.hasBlock());
    }

    protected boolean hasBlock() {
        return this.item.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)this.center.getBlockData()));
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        boolean invert;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new BlockSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                String[] split = RegexUtil.COLON_PATTERN.split(PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)), 2);
                Integer.parseInt(split[0]);
            }
            catch (Exception ignored) {
                throw new ICVerificationException("You need to specify a block in line four.");
            }
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Checks for blocks at location.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"x:y:z", "id:data"};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            this.invert = config.getBoolean("invert-output", false);
        }
    }
}

