/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import org.bukkit.Server;
import org.bukkit.entity.ExperienceOrb;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;

public class XPSpawner
extends AbstractIC {
    int amount;
    int orbs;

    public XPSpawner(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            this.amount = Integer.parseInt(this.getLine(2));
        }
        catch (Exception e) {
            this.amount = 1;
        }
        try {
            this.orbs = Integer.parseInt(this.getLine(3));
        }
        catch (Exception e) {
            this.orbs = 1;
        }
    }

    @Override
    public String getTitle() {
        return "Experience Orb Spawner";
    }

    @Override
    public String getSignTitle() {
        return "XP SPAWNER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            for (int i = 0; i < this.orbs; ++i) {
                ExperienceOrb orb = (ExperienceOrb)this.getLocation().getWorld().spawn(this.getLocation().add(0.5, 1.5, 0.5), ExperienceOrb.class);
                orb.setExperience(this.amount);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new XPSpawner(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Spawns an XP Orb.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"amount of xp", "amount of orbs"};
        }
    }
}

