/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.extension.platform.Actor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICMechanic;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous.WirelessTransmitter;

public class WirelessReceiver
extends AbstractSelfTriggeredIC {
    private String band;

    public WirelessReceiver(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.band = this.getLine(2);
        if (!this.getLine(3).trim().isEmpty()) {
            this.band = this.band + this.getLine(3);
        }
    }

    @Override
    public String getTitle() {
        return "Wireless Receiver";
    }

    @Override
    public String getSignTitle() {
        return "RECEIVER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.getOutput());
        }
    }

    public boolean getOutput() {
        Boolean val = WirelessTransmitter.getValue(this.band);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.getOutput());
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        public boolean requirename;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new WirelessReceiver(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1111''' receives the state in a particular ''band'' or ''network'' when the clock input goes from low to high.", "The corresponding transmitter is the [[../MC1110/]] IC.", "", "If there are multiple transmitters for the same band, the last one to transmit to a particular band will have its state apply until the next transmission."};
        }

        @Override
        public String getShortDescription() {
            return "Recieves signal from wireless transmitter.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "State of Wireless Band"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Wireless Band", "Player's CBID (Automatic)"};
        }

        @Override
        public void checkPlayer(BukkitChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            if (this.requirename && (line3.isEmpty() || !ICMechanic.hasRestrictedPermissions((Actor)player, this, "MC1111"))) {
                sign.setLine(3, (Component)Component.text((String)player.getCraftBookId()));
            } else if (!line3.isEmpty() && !ICMechanic.hasRestrictedPermissions((Actor)player, this, "MC1111")) {
                sign.setLine(3, (Component)Component.text((String)player.getCraftBookId()));
            }
            sign.update(false);
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            config.setComment("per-player", "Require a name to be entered on the sign. This allows for 'per-player' wireless bands. This is done automatically.");
            this.requirename = config.getBoolean("per-player", false);
        }
    }
}

