/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SearchArea;
import org.enginehub.craftbook.util.jinglenote.JingleNoteManager;
import org.enginehub.craftbook.util.jinglenote.StringJingleSequencer;

public class Tune
extends AbstractSelfTriggeredIC {
    StringJingleSequencer sequencer;
    JingleNoteManager jNote;
    SearchArea area;
    int delay;
    String tune;

    public Tune(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Tune Player";
    }

    @Override
    public String getSignTitle() {
        return "TUNE";
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            if (this.sequencer == null) {
                this.sequencer = new StringJingleSequencer(this.tune, this.delay);
            }
            if (this.sequencer.isPlaying() || !this.sequencer.hasPlayedBefore()) {
                for (Player player : this.getServer().getOnlinePlayers()) {
                    if (!this.area.isWithinArea(player.getLocation())) {
                        if (!this.jNote.isPlaying(player.getName())) continue;
                        this.jNote.stop(player.getName());
                        continue;
                    }
                    if (this.jNote.isPlaying(player.getName())) continue;
                    this.jNote.play(player.getName(), this.sequencer, this.area);
                }
            }
        } else if (!chip.getInput(0) && this.sequencer != null) {
            this.sequencer.stop();
            this.jNote.stopAll();
            this.sequencer = null;
        }
        chip.setOutput(0, this.sequencer != null && this.sequencer.isPlaying());
    }

    @Override
    public void load() {
        this.area = !this.getLine(3).isEmpty() ? SearchArea.createArea(this.getLocation().getBlock(), this.getLine(3)) : SearchArea.createEmptyArea();
        if (this.getLine(2).contains(":")) {
            String[] split = RegexUtil.COLON_PATTERN.split(this.getLine(2), 2);
            try {
                this.delay = Integer.parseInt(split[0]);
            }
            catch (Exception e) {
                this.delay = 2;
            }
            this.tune = split[1];
        } else {
            this.tune = this.getLine(2);
            this.delay = 2;
        }
        this.jNote = new JingleNoteManager();
    }

    @Override
    public void unload() {
        try {
            this.jNote.stopAll();
            this.sequencer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String getShortDescription() {
            return "Plays a tune.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Delay:Tune", "Radius"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Tune(this.getServer(), sign, this);
        }
    }
}

