/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.world.miscellaneous;

import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.RegexUtil;

public class TimedExplosion
extends AbstractIC {
    private int ticks;
    private float yield;
    private boolean flamey;
    private Block center;

    public TimedExplosion(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        if (this.getLine(3).length() > 0 && !this.getLine(3).contains(":")) {
            this.getSign().setLine(2, (Component)Component.text((String)(this.getLine(2) + ":" + this.getLine(3))));
            this.getSign().update(false);
        }
        try {
            this.ticks = Integer.parseInt(RegexUtil.COLON_PATTERN.split(this.getLine(2).replace("!", ""))[0]);
        }
        catch (Exception e) {
            this.ticks = -1;
        }
        try {
            this.yield = Float.parseFloat(RegexUtil.COLON_PATTERN.split(this.getLine(2).replace("!", ""))[1]);
        }
        catch (Exception e) {
            this.yield = -1.0f;
        }
        try {
            this.flamey = this.getLine(2).endsWith("!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.center = ICUtil.parseBlockLocation(this.getSign(), 3);
    }

    @Override
    public String getTitle() {
        return "Timed Explosive";
    }

    @Override
    public String getSignTitle() {
        return "TIME BOMB";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Location loc = this.center.getLocation();
            if (!loc.getChunk().isLoaded()) {
                return;
            }
            while (loc.getBlock().getType().isSolid()) {
                loc = loc.add(0.0, 1.0, 0.0);
            }
            TNTPrimed tnt = (TNTPrimed)loc.getWorld().spawnEntity(BlockUtil.getBlockCentre(loc.getBlock()), EntityType.TNT);
            tnt.setIsIncendiary(this.flamey);
            if (this.ticks > 0) {
                tnt.setFuseTicks(this.ticks);
            }
            if (this.yield > 0.0f) {
                tnt.setYield(this.yield);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new TimedExplosion(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Spawn tnt with custom fuse and yield.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"time in ticks:radius (ending with ! makes fire)", "x:y:z offset"};
        }
    }
}

